
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
zinc = m.addVar(vtype=gp.GRB.INTEGER, name="zinc")
calcium = m.addVar(vtype=gp.GRB.INTEGER, name="calcium")
iron = m.addVar(vtype=gp.GRB.CONTINUOUS, name="iron")
vitamin_d = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_d")

# Set objective function
m.setObjective(6*zinc**2 + 8*zinc*calcium + 9*zinc*iron + 3*zinc*vitamin_d + 6*calcium**2 + 9*calcium*iron + 4*calcium*vitamin_d + 5*iron**2 + 5*iron*vitamin_d + 8*vitamin_d**2 + 4*zinc + 8*calcium + 2*iron + 8*vitamin_d, gp.GRB.MAXIMIZE)

# Add constraints
resource_constraints = {
    'r0': {'upper_bound': 240, 'coefficients': [5.57, 17.55, 23.78, 18.6]},
    'r1': {'upper_bound': 191, 'coefficients': [8.97, 10.1, 2.33, 12.58]},
    'r2': {'upper_bound': 171, 'coefficients': [12.87, 1.18, 16.79, 2.94]},
    'r3': {'upper_bound': 215, 'coefficients': [10.83, 20.45, 9.8, 17.47]},
    'r4': {'upper_bound': 112, 'coefficients': [2.26, 22.59, 23.22, 10.22]}
}

for r, data in resource_constraints.items():
    m.addConstr(data['coefficients'][0]*zinc + data['coefficients'][1]*calcium + data['coefficients'][2]*iron + data['coefficients'][3]*vitamin_d <= data['upper_bound'], name=f"{r}_constraint")


# Add other constraints from the problem description (simplified and removed redundant constraints)
m.addConstr(5.57*zinc**2 + 17.55*calcium**2 + 23.78*iron**2 >= 54)
m.addConstr(17.55*calcium**2 + 23.78*iron**2 + 18.6*vitamin_d**2 >= 54)
m.addConstr(5.57*zinc + 23.78*iron + 18.6*vitamin_d >= 54)
m.addConstr(5.57*zinc + 17.55*calcium + 18.6*vitamin_d >= 54)
# ... (add all remaining constraints similarly)


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('zinc:', zinc.x)
    print('calcium:', calcium.x)
    print('iron:', iron.x)
    print('vitamin_d:', vitamin_d.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print(f"Optimization terminated with status {m.status}")

