
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    dale = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Dale")
    george = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="George")
    john = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="John")
    bobby = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Bobby")


    # Set objective function
    m.setObjective(7*dale + 8*george + 4*john + 8*bobby, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(3.43*george + 3.24*john >= 26)
    m.addConstr(0.78*dale + 3.43*george >= 21)
    m.addConstr(0.78*dale + 4.78*bobby >= 12)
    m.addConstr(3.43*george + 4.78*bobby >= 16)
    m.addConstr(0.78*dale + 3.43*george + 3.24*john >= 22)
    m.addConstr(0.78*dale + 3.43*george + 3.24*john + 4.78*bobby >= 22)
    m.addConstr(3.83*dale + 4.7*bobby >= 26)
    m.addConstr(3.83*dale + 0.95*george >= 19)
    m.addConstr(0.95*george + 4.7*bobby >= 20)
    m.addConstr(3.83*dale + 3.48*john >= 30)
    m.addConstr(3.83*dale + 0.95*george + 3.48*john + 4.7*bobby >= 30)
    m.addConstr(-7*john + 4*bobby >= 0)
    m.addConstr(-10*george + 10*bobby >= 0)
    m.addConstr(3.24*john + 4.78*bobby <= 42)
    m.addConstr(0.78*dale + 4.78*bobby <= 81)
    m.addConstr(3.43*george + 4.78*bobby <= 63)
    m.addConstr(0.78*dale + 3.43*george <= 114)
    m.addConstr(0.78*dale + 3.43*george + 4.78*bobby <= 126)
    m.addConstr(3.43*george + 3.24*john + 4.78*bobby <= 53)
    m.addConstr(3.83*dale + 0.95*george <= 92)
    m.addConstr(3.83*dale + 3.48*john + 4.7*bobby <= 78)
    m.addConstr(3.83*dale + 0.95*george + 3.48*john <= 87)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
