
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by Dale
    x1 = model.addVar(name="x1", lb=0)  # hours worked by George
    x2 = model.addVar(name="x2", lb=0)  # hours worked by John
    x3 = model.addVar(name="x3", lb=0)  # hours worked by Bobby

    # Objective function
    model.setObjective(7 * x0 + 8 * x1 + 4 * x2 + 8 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(0.78 * x0 <= 144)
    model.addConstr(3.83 * x0 <= 121)
    model.addConstr(3.43 * x1 <= 144)
    model.addConstr(0.95 * x1 <= 121)
    model.addConstr(3.24 * x2 <= 144)
    model.addConstr(3.48 * x2 <= 121)
    model.addConstr(4.78 * x3 <= 144)
    model.addConstr(4.7 * x3 <= 121)

    model.addConstr(3.43 * x1 + 3.24 * x2 >= 26)
    model.addConstr(0.78 * x0 + 3.43 * x1 >= 21)
    model.addConstr(0.78 * x0 + 4.78 * x3 >= 12)
    model.addConstr(3.43 * x1 + 4.78 * x3 >= 16)
    model.addConstr(0.78 * x0 + 3.43 * x1 + 3.24 * x2 >= 22)
    model.addConstr(0.78 * x0 + 3.43 * x1 + 3.24 * x2 + 4.78 * x3 >= 22)
    model.addConstr(3.83 * x0 + 4.7 * x3 >= 26)
    model.addConstr(3.83 * x0 + 0.95 * x1 >= 19)
    model.addConstr(0.95 * x1 + 4.7 * x3 >= 20)
    model.addConstr(3.83 * x0 + 3.48 * x2 >= 30)
    model.addConstr(3.83 * x0 + 0.95 * x1 + 3.48 * x2 + 4.7 * x3 >= 30)

    model.addConstr(-7 * x2 + 4 * x3 >= 0)
    model.addConstr(-10 * x1 + 10 * x3 >= 0)

    model.addConstr(3.24 * x2 + 4.78 * x3 <= 42)
    model.addConstr(0.78 * x0 + 4.78 * x3 <= 81)
    model.addConstr(3.43 * x1 + 4.78 * x3 <= 63)
    model.addConstr(0.78 * x0 + 3.43 * x1 <= 114)
    model.addConstr(0.78 * x0 + 3.43 * x1 + 4.78 * x3 <= 126)
    model.addConstr(3.43 * x1 + 3.24 * x2 + 4.78 * x3 <= 53)
    model.addConstr(3.83 * x0 + 0.95 * x1 <= 92)
    model.addConstr(3.83 * x0 + 3.48 * x2 + 4.7 * x3 <= 78)
    model.addConstr(3.83 * x0 + 0.95 * x1 + 3.48 * x2 <= 87)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("x0: ", x0.varValue)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
