
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(4, lb=0, names=["Jean", "Mary", "Dale", "George"])


# Set objective function
m.setObjective(2.91 * x[0] + 3.45 * x[1] + 1.14 * x[2] + 4.72 * x[3], gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(10.53 * x[0] + 1.28 * x[3] >= 73)
m.addConstr(1.71 * x[1] + 11.54 * x[2] >= 118)
m.addConstr(10.53 * x[0] + 1.71 * x[1] >= 40)
m.addConstr(11.54 * x[2] + 1.28 * x[3] >= 82)
m.addConstr(1.71 * x[1] + 1.28 * x[3] >= 97)
m.addConstr(10.53 * x[0] + 1.71 * x[1] + 11.54 * x[2] + 1.28 * x[3] >= 97)
m.addConstr(0.2 * x[1] + 1.28 * x[2] >= 36)
m.addConstr(0.2 * x[1] + 5.29 * x[3] >= 75)
m.addConstr(0.2 * x[1] + 1.28 * x[2] + 5.29 * x[3] >= 63)
m.addConstr(11.67 * x[0] + 0.2 * x[1] + 5.29 * x[3] >= 63)
m.addConstr(0.2 * x[1] + 1.28 * x[2] + 5.29 * x[3] >= 54)
m.addConstr(11.67 * x[0] + 0.2 * x[1] + 5.29 * x[3] >= 54)
m.addConstr(11.67 * x[0] + 0.2 * x[1] + 1.28 * x[2] + 5.29 * x[3] >= 54)
m.addConstr(10.1 * x[1] + 3.42 * x[3] >= 62)
m.addConstr(10.1 * x[1] + 0.78 * x[2] >= 105)
m.addConstr(11.46 * x[0] + 3.42 * x[3] >= 108)
m.addConstr(0.78 * x[2] + 3.42 * x[3] >= 82)
m.addConstr(11.46 * x[0] + 10.1 * x[1] + 3.42 * x[3] >= 73)
m.addConstr(11.46 * x[0] + 10.1 * x[1] + 0.78 * x[2] + 3.42 * x[3] >= 73)
m.addConstr(1.57 * x[1] + 2.1 * x[2] >= 84)
m.addConstr(2.1 * x[2] + 2.78 * x[3] >= 41)
m.addConstr(8.17 * x[0] + 2.1 * x[2] >= 102)
m.addConstr(8.17 * x[0] + 2.78 * x[3] >= 46)
m.addConstr(8.17 * x[0] + 1.57 * x[1] + 2.1 * x[2] >= 113)
m.addConstr(1.57 * x[1] + 2.1 * x[2] + 2.78 * x[3] >= 113)
m.addConstr(8.17 * x[0] + 1.57 * x[1] + 2.1 * x[2] >= 67)
m.addConstr(1.57 * x[1] + 2.1 * x[2] + 2.78 * x[3] >= 67)
m.addConstr(8.17 * x[0] + 1.57 * x[1] + 2.1 * x[2] + 2.78 * x[3] >= 67)
m.addConstr(0.13 * x[1] + 1.83 * x[3] >= 28)
m.addConstr(0.97 * x[0] + 0.13 * x[1] >= 21)
m.addConstr(0.97 * x[0] + 1.83 * x[3] >= 61)
m.addConstr(0.13 * x[1] + 11.15 * x[2] + 1.83 * x[3] >= 49)
m.addConstr(0.97 * x[0] + 0.13 * x[1] + 11.15 * x[2] >= 49)
m.addConstr(0.13 * x[1] + 11.15 * x[2] + 1.83 * x[3] >= 58)
m.addConstr(0.97 * x[0] + 0.13 * x[1] + 11.15 * x[2] >= 58)
m.addConstr(0.97 * x[0] + 0.13 * x[1] + 11.15 * x[2] + 1.83 * x[3] >= 58)
m.addConstr(7 * x[2] - 2 * x[3] >= 0)
m.addConstr(6 * x[1] - 8 * x[3] >= 0)
m.addConstr(10.53 * x[0] + 1.71 * x[1] + 1.28 * x[3] <= 421)
m.addConstr(10.53 * x[0] + 1.71 * x[1] + 11.54 * x[2] <= 199)
m.addConstr(11.67 * x[0] + 1.28 * x[2] + 5.29 * x[3] <= 156)
m.addConstr(11.67 * x[0] + 0.2 * x[1] + 5.29 * x[3] <= 231)
m.addConstr(11.46 * x[0] + 10.1 * x[1] <= 333)
m.addConstr(2.1 * x[2] + 2.78 * x[3] <= 201)
m.addConstr(1.57 * x[1] + 2.1 * x[2] <= 394)
m.addConstr(8.17 * x[0] + 2.78 * x[3] <= 450)
m.addConstr(1.57 * x[1] + 2.78 * x[3] <= 289)
m.addConstr(8.17 * x[0] + 1.57 * x[1] <= 363)
m.addConstr(8.17 * x[0] + 2.1 * x[2] <= 241)
m.addConstr(0.97 * x[0] + 0.13 * x[1] + 1.83 * x[3] <= 241)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective Value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

