
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="grams_of_fiber")
    x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="milligrams_of_vitamin_B3")


    # Set objective function
    m.setObjective(3.32*x0**2 + 2.46*x0*x1 + 4.23*x1**2 + 7.99*x0 + 6.8*x1, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(6*x0 + 20*x1 >= 55, "c0")
    m.addConstr(x0**2 + x1**2 >= 45, "c1")
    m.addConstr(x0 + x1 >= 45, "c2")
    m.addConstr(9*x0 + 24*x1 >= 47, "c3")
    m.addConstr(16*x0**2 + 26*x1**2 >= 81, "c4")
    m.addConstr(16*x0 + 26*x1 >= 81, "c5")
    m.addConstr(-4*x0 + x1 >= 0, "c6")
    m.addConstr(6*x0 + 20*x1 <= 95, "c7")
    m.addConstr(x0 + x1 <= 138, "c8")
    m.addConstr(9*x0 + 24*x1 <= 121, "c9")
    m.addConstr(16*x0 + 26*x1 <= 105, "c10")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('grams_of_fiber:', x0.x)
        print('milligrams_of_vitamin_B3:', x1.x)
    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
