
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="grams_of_fiber", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x2 = m.addVar(name="milligrams_of_vitamin_B3", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(3.32*x1**2 + 2.46*x1*x2 + 4.23*x2**2 + 7.99*x1 + 6.8*x2, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(6*x1 + 20*x2 >= 55, name="digestive_support_index_min")
m.addConstr(x1**2 + x2**2 >= 45, name="kidney_support_index_min")
m.addConstr(9*x1 + 24*x2 >= 47, name="cardiovascular_support_index_min")
m.addConstr(16*x1**2 + 26*x2**2 >= 81, name="muscle_growth_index_min")
m.addConstr(16*x1 + 26*x2 >= 81, name="muscle_growth_index_min_linear")
m.addConstr(-4*x1 + x2 >= 0, name="linear_constraint")
m.addConstr(6*x1 + 20*x2 <= 95, name="digestive_support_index_max")
m.addConstr(1*x1 + 1*x2 <= 138, name="kidney_support_index_max")
m.addConstr(9*x1 + 24*x2 <= 121, name="cardiovascular_support_index_max")
m.addConstr(16*x1 + 26*x2 <= 105, name="muscle_growth_index_max")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("Grams of fiber: ", x1.varValue)
    print("Milligrams of vitamin B3: ", x2.varValue)
else:
    print("The model is infeasible")
