
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_B7")
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_B12")
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="calcium")


    # Set objective function
    m.setObjective(1*x0 + 7*x1 + 1*x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(11*x0 + 7*x2 >= 82, "c0")
    m.addConstr(11*x0 + 7*x1 >= 77, "c1")
    m.addConstr(11*x0 + 7*x1 + 7*x2 >= 77, "c2")
    m.addConstr(7*x0 + 22*x1 >= 42, "c3")
    m.addConstr(7*x0 + 22*x1 + 18*x2 >= 42, "c4")
    m.addConstr(20*x1 + 13*x2 >= 58, "c5")
    m.addConstr(3*x0 + 13*x2 >= 50, "c6")
    m.addConstr(3*x0 + 20*x1 + 13*x2 >= 50, "c7")
    m.addConstr(6*x0 - 2*x1 >= 0, "c8")
    m.addConstr(11*x0 + 7*x2 <= 161, "c9")
    m.addConstr(11*x0 + 7*x1 + 7*x2 <= 196, "c10")
    m.addConstr(7*x0 + 18*x2 <= 221, "c11")
    m.addConstr(3*x0 + 20*x1 + 13*x2 <= 93, "c12")

    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('vitamin_B7:', x0.x)
        print('vitamin_B12:', x1.x)
        print('calcium:', x2.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
