
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", lb=0)  # milligrams of vitamin B7
    x2 = model.addVar(name="x2", lb=0)  # milligrams of vitamin B12
    x3 = model.addVar(name="x3", lb=0)  # milligrams of calcium

    # Objective function: Minimize 1*x1 + 7*x2 + 1*x3
    model.setObjective(1 * x1 + 7 * x2 + 1 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(11 * x1 + 7 * x3 >= 82)
    model.addConstr(11 * x1 + 7 * x2 >= 77)
    model.addConstr(11 * x1 + 7 * x2 + 7 * x3 >= 77)
    model.addConstr(7 * x1 + 22 * x2 >= 42)
    model.addConstr(7 * x1 + 22 * x2 + 18 * x3 >= 42)
    model.addConstr(20 * x2 + 13 * x3 >= 58)
    model.addConstr(3 * x1 + 13 * x3 >= 50)
    model.addConstr(3 * x1 + 20 * x2 + 13 * x3 >= 50)
    model.addConstr(6 * x1 - 2 * x2 >= 0)
    model.addConstr(11 * x1 + 7 * x3 <= 161)
    model.addConstr(11 * x1 + 7 * x2 + 7 * x3 <= 196)
    model.addConstr(7 * x1 + 18 * x3 <= 221)
    model.addConstr(3 * x1 + 20 * x2 + 13 * x3 <= 93)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"x1: {x1.varValue}")
        print(f"x2: {x2.varValue}")
        print(f"x3: {x3.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
