
import gurobipy as gp

# Create a new model
model = gp.Model("Maximize Ravioli and Cherry Pies")

# Create variables
ravioli = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ravioli")
cherry_pies = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cherry_pies")

# Set objective function
model.setObjective(3.16 * ravioli + 7.63 * cherry_pies, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(17 * ravioli + 8 * cherry_pies >= 20, "carbohydrates_min")
model.addConstr(9 * ravioli + 2 * cherry_pies >= 22, "umami_min")
model.addConstr(2 * ravioli - 2 * cherry_pies >= 0, "ravioli_cherry_pies_ratio")
model.addConstr(17 * ravioli + 8 * cherry_pies <= 39, "carbohydrates_max")
model.addConstr(9 * ravioli + 2 * cherry_pies <= 37, "umami_max")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print(f"Ravioli: {ravioli.x}")
    print(f"Cherry Pies: {cherry_pies.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

