
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="ravioli")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="cherry_pies")

# Set the objective function
m.setObjective(3.16*x1 + 7.63*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(17*x1 + 8*x2 >= 20, "carbohydrates_min")
m.addConstr(9*x1 + 2*x2 >= 22, "umami_min")
m.addConstr(2*x1 - 2*x2 >= 0, "ravioli_vs_pies")
m.addConstr(17*x1 + 8*x2 <= 39, "carbohydrates_max")
m.addConstr(9*x1 + 2*x2 <= 37, "umami_max")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Ravioli: {x1.x}, Cherry Pies: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found.")
