
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="ravioli", lb=0)  # ravioli
x2 = model.addVar(name="cherry_pies", lb=0)  # cherry pies

# Objective function: maximize 3.16 * ravioli + 7.63 * cherry_pies
model.setObjective(3.16 * x1 + 7.63 * x2, gurobi.GRB.MAXIMIZE)

# Constraints
model.addConstr(17 * x1 + 8 * x2 >= 20, name="carbohydrates_min")
model.addConstr(9 * x1 + 2 * x2 >= 22, name="umami_min")
model.addConstr(2 * x1 - 2 * x2 >= 0, name="ravioli_vs_cherry")
model.addConstr(17 * x1 + 8 * x2 <= 39, name="carbohydrates_max")
model.addConstr(9 * x1 + 2 * x2 <= 37, name="umami_max")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Ravioli: {x1.varValue}")
    print(f"Cherry pies: {x2.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
