
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="blue_highlighters")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="color_printers")
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="red_pens")

    # Set objective function
    m.setObjective(3.37 * x0 + 5.98 * x1 + 2.31 * x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(9.17 * x0 + 9.85 * x2 >= 25)
    m.addConstr(9.17 * x0 + 12.84 * x1 >= 22)
    m.addConstr(12.84 * x1 + 9.85 * x2 >= 18)
    m.addConstr(1.48 * x0 + 6.63 * x1 + 3.21 * x2 >= 80)
    m.addConstr(2.85 * x0 + 4.42 * x2 >= 37)
    m.addConstr(5.02 * x0 + 0.48 * x2 >= 29)
    m.addConstr(6.01 * x1 + 0.48 * x2 >= 34)
    m.addConstr(12.84 * x1 + 9.85 * x2 <= 76)
    m.addConstr(9.17 * x0 + 9.85 * x2 <= 79)
    m.addConstr(9.17 * x0 + 12.84 * x1 <= 56)
    m.addConstr(9.17 * x0 + 12.84 * x1 + 9.85 * x2 <= 40)
    m.addConstr(1.48 * x0 + 3.21 * x2 <= 318)
    m.addConstr(6.63 * x1 + 3.21 * x2 <= 191)
    m.addConstr(1.48 * x0 + 6.63 * x1 + 3.21 * x2 <= 191)
    m.addConstr(2.85 * x0 + 4.42 * x2 <= 130)
    m.addConstr(8.24 * x1 + 4.42 * x2 <= 101)
    m.addConstr(2.85 * x0 + 8.24 * x1 + 4.42 * x2 <= 101)
    m.addConstr(5.02 * x0 + 0.48 * x2 <= 93)
    m.addConstr(5.02 * x0 + 6.01 * x1 <= 56)
    m.addConstr(5.02 * x0 + 6.01 * x1 + 0.48 * x2 <= 56)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Objective Value:', m.objVal)
        for v in m.getVars():
            print(f'{v.varName}: {v.x}')
    elif m.status == gp.GRB.INFEASIBLE:
        print("The problem is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
