
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="blue_highlighters", vtype=gurobi.GRB.INTEGER)
x1 = model.addVar(name="color_printers", vtype=gurobi.GRB.INTEGER)
x2 = model.addVar(name="red_pens", vtype=gurobi.GRB.INTEGER)

# Define the objective function
model.setObjective(3.37*x0 + 5.98*x1 + 2.31*x2, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(9.17*x0 + 12.84*x1 + 9.85*x2 <= 93)
model.addConstr(9.17*x0 + 9.85*x2 >= 25)
model.addConstr(9.17*x0 + 12.84*x1 >= 22)
model.addConstr(12.84*x1 + 9.85*x2 >= 18)
model.addConstr(1.48*x0 + 6.63*x1 + 3.21*x2 >= 80)
model.addConstr(2.85*x0 + 4.42*x2 >= 37)
model.addConstr(5.02*x0 + 0.48*x2 >= 29)
model.addConstr(6.01*x1 + 0.48*x2 >= 34)
model.addConstr(12.84*x1 + 9.85*x2 <= 76)
model.addConstr(9.17*x0 + 9.85*x2 <= 79)
model.addConstr(9.17*x0 + 12.84*x1 <= 56)
model.addConstr(9.17*x0 + 12.84*x1 + 9.85*x2 <= 40)
model.addConstr(1.48*x0 + 3.21*x2 <= 318)
model.addConstr(6.63*x1 + 3.21*x2 <= 191)
model.addConstr(1.48*x0 + 6.63*x1 + 3.21*x2 <= 191)
model.addConstr(2.85*x0 + 4.42*x2 <= 130)
model.addConstr(8.24*x1 + 4.42*x2 <= 101)
model.addConstr(2.85*x0 + 8.24*x1 + 4.42*x2 <= 101)
model.addConstr(5.02*x0 + 0.48*x2 <= 93)
model.addConstr(5.02*x0 + 6.01*x1 <= 56)
model.addConstr(5.02*x0 + 6.01*x1 + 0.48*x2 <= 56)

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("Blue highlighters: ", x0.varValue)
    print("Color printers: ", x1.varValue)
    print("Red pens: ", x2.varValue)
else:
    print("The model is infeasible")
