
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
bananas = m.addVar(lb=0, name="bananas")
chicken_thighs = m.addVar(lb=0, name="chicken_thighs")
protein_bars = m.addVar(lb=0, name="protein_bars")
rotisserie_chickens = m.addVar(lb=0, name="rotisserie_chickens")


# Set objective function
m.setObjective(4.62*bananas**2 + 1.3*bananas*chicken_thighs + 8.08*bananas*protein_bars + 7.51*bananas*rotisserie_chickens + 3.8*chicken_thighs**2 + 1.42*chicken_thighs*protein_bars + 9.75*chicken_thighs*rotisserie_chickens + 8.05*protein_bars**2 + 4.96*protein_bars*rotisserie_chickens + 3.83*rotisserie_chickens**2 + 7.94*bananas + 1.99*chicken_thighs + 3.79*protein_bars, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(chicken_thighs**2 + rotisserie_chickens**2 >= 43)
m.addConstr(bananas + chicken_thighs + protein_bars >= 54)
m.addConstr(bananas + protein_bars + rotisserie_chickens >= 54)
m.addConstr(bananas + chicken_thighs + protein_bars >= 46)
m.addConstr(bananas + protein_bars + rotisserie_chickens >= 46)
m.addConstr(chicken_thighs**2 + protein_bars**2 <= 130)
m.addConstr(bananas**2 + protein_bars**2 <= 109)
m.addConstr(bananas + rotisserie_chickens <= 230)
m.addConstr(protein_bars + rotisserie_chickens <= 203)
m.addConstr(chicken_thighs + rotisserie_chickens <= 78)
m.addConstr(bananas**2 + chicken_thighs**2 <= 180)
m.addConstr(bananas + chicken_thighs + protein_bars + rotisserie_chickens <= 180)
m.addConstr(1*bananas + 9*chicken_thighs + 3*protein_bars + 8*rotisserie_chickens <= 248)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

