
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
bananas = model.addVar(name="bananas", lb=0)
chicken_thighs = model.addVar(name="chicken thighs", lb=0)
protein_bars = model.addVar(name="protein bars", lb=0)
rotisserie_chickens = model.addVar(name="rotisserie chickens", lb=0)

# Define the objective function
model.setObjective(4.62 * bananas**2 + 1.3 * bananas * chicken_thighs + 8.08 * bananas * protein_bars + 7.51 * bananas * rotisserie_chickens +
                   3.8 * chicken_thighs**2 + 1.42 * chicken_thighs * protein_bars + 9.75 * chicken_thighs * rotisserie_chickens +
                   8.05 * protein_bars**2 + 4.96 * protein_bars * rotisserie_chickens + 3.83 * rotisserie_chickens**2 +
                   7.94 * bananas + 1.99 * chicken_thighs + 3.79 * protein_bars, gurobi.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(9 * chicken_thighs**2 + 8 * rotisserie_chickens**2 >= 43)
model.addConstr(bananas + 9 * chicken_thighs + 3 * protein_bars >= 54)
model.addConstr(bananas + 3 * protein_bars + 8 * rotisserie_chickens >= 54)
model.addConstr(bananas + 9 * chicken_thighs + 3 * protein_bars >= 46)
model.addConstr(bananas + 3 * protein_bars + 8 * rotisserie_chickens >= 46)
model.addConstr(9 * chicken_thighs**2 + 3 * protein_bars**2 <= 130)
model.addConstr(bananas**2 + 3 * protein_bars**2 <= 109)
model.addConstr(bananas + 8 * rotisserie_chickens <= 230)
model.addConstr(3 * protein_bars + 8 * rotisserie_chickens <= 203)
model.addConstr(9 * chicken_thighs + 8 * rotisserie_chickens <= 78)
model.addConstr(bananas**2 + 9 * chicken_thighs**2 <= 180)
model.addConstr(bananas + 9 * chicken_thighs + 3 * protein_bars + 8 * rotisserie_chickens <= 180)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Bananas: {bananas.varValue}")
    print(f"Chicken Thighs: {chicken_thighs.varValue}")
    print(f"Protein Bars: {protein_bars.varValue}")
    print(f"Rotisserie Chickens: {rotisserie_chickens.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
