
from gurobipy import Model, GRB, quicksum

# Create a new model
m = Model("optimization_problem")

# Create variables
apples = m.addVar(vtype=GRB.INTEGER, name="apples")
black_beans = m.addVar(vtype=GRB.INTEGER, name="black_beans")
steaks = m.addVar(vtype=GRB.INTEGER, name="steaks")
protein_bars = m.addVar(vtype=GRB.INTEGER, name="protein_bars")
strips_of_bacon = m.addVar(vtype=GRB.INTEGER, name="strips_of_bacon")
fruit_salads = m.addVar(vtype=GRB.INTEGER, name="fruit_salads")


# Set objective function
m.setObjective(9*apples**2 + 6*apples*black_beans + 3*apples*steaks + 7*apples*protein_bars + 8*apples*strips_of_bacon + 7*apples*fruit_salads + 7*black_beans**2 + 6*black_beans*steaks + 2*black_beans*protein_bars + 8*black_beans*strips_of_bacon + 3*black_beans*fruit_salads + 8*steaks**2 + 8*steaks*protein_bars + 1*steaks*strips_of_bacon + 2*steaks*fruit_salads + 4*protein_bars**2 + 1*protein_bars*strips_of_bacon + 9*protein_bars*fruit_salads + 4*strips_of_bacon**2 + 8*strips_of_bacon*fruit_salads + 9*fruit_salads**2 + 9*apples + 7*black_beans + 4*steaks + 3*protein_bars + 8*strips_of_bacon + 3*fruit_salads, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*steaks**2 + 1*strips_of_bacon**2 >= 11)
m.addConstr(2*black_beans + 7*steaks >= 16)
m.addConstr(5*apples + 2*black_beans >= 8)
m.addConstr(2*black_beans**2 + 11*protein_bars**2 >= 26)
m.addConstr(7*steaks + 11*protein_bars >= 18)
m.addConstr(5*apples**2 + 1*strips_of_bacon**2 >= 10)
m.addConstr(7*steaks + 5*fruit_salads >= 23)
m.addConstr(2*black_beans + 7*steaks + 11*protein_bars >= 25)
m.addConstr(5*apples**2 + 2*black_beans**2 + 11*protein_bars**2 >= 25)
m.addConstr(2*black_beans + 7*steaks + 11*protein_bars >= 23)
m.addConstr(5*apples + 2*black_beans + 11*protein_bars >= 23)
m.addConstr(5*apples + 2*black_beans + 7*steaks + 11*protein_bars + 1*strips_of_bacon + 5*fruit_salads >= 23)
m.addConstr(10*black_beans + 3*protein_bars >= 38)
m.addConstr(10*black_beans + 7*strips_of_bacon >= 36)
m.addConstr(7*strips_of_bacon + 3*fruit_salads >= 30)
m.addConstr(3*protein_bars**2 + 3*fruit_salads**2 >= 47)
m.addConstr(5*apples + 10*black_beans + 9*steaks + 3*protein_bars + 7*strips_of_bacon + 3*fruit_salads >= 47)
m.addConstr(-6*black_beans + 7*fruit_salads >= 0)
m.addConstr(5*apples**2 + 11*protein_bars**2 <= 155)
m.addConstr(10*black_beans + 3*protein_bars + 7*strips_of_bacon <= 368)
m.addConstr(5*apples + 9*steaks + 3*fruit_salads <= 92)
m.addConstr(10*black_beans**2 + 3*protein_bars**2 + 3*fruit_salads**2 <= 249)
m.addConstr(5*apples + 7*strips_of_bacon + 3*fruit_salads <= 117)
m.addConstr(10*black_beans + 9*steaks + 3*protein_bars <= 298)
m.addConstr(5*apples**2 + 3*protein_bars**2 + 7*strips_of_bacon**2 <= 298)
m.addConstr(5*apples + 10*black_beans + 3*fruit_salads <= 315)
m.addConstr(5*apples + 10*black_beans + 9*steaks <= 135)

m.addConstr(5*apples + 2*black_beans + 7*steaks + 11*protein_bars + 1*strips_of_bacon + 5*fruit_salads <= 157)
m.addConstr(5*apples + 10*black_beans + 9*steaks + 3*protein_bars + 7*strips_of_bacon + 3*fruit_salads <= 384)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('\nCost: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("Optimization ended with status:", m.status)

