
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="apples", vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name="black_beans", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="steaks", vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name="protein_bars", vtype=gurobi.GRB.INTEGER)
x4 = m.addVar(name="strips_of_bacon", vtype=gurobi.GRB.INTEGER)
x5 = m.addVar(name="fruit_salads", vtype=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(9*x0**2 + 6*x0*x1 + 3*x0*x2 + 7*x0*x3 + 8*x0*x4 + 7*x0*x5 + 
               7*x1**2 + 6*x1*x2 + 2*x1*x3 + 8*x1*x4 + 3*x1*x5 + 
               8*x2**2 + 8*x2*x3 + x2*x4 + 2*x2*x5 + 
               4*x3**2 + x3*x4 + 9*x3*x5 + 
               4*x4**2 + 8*x4*x5 + 
               9*x5**2 + 
               9*x0 + 7*x1 + 4*x2 + 3*x3 + 8*x4 + 3*x5, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(5*x0 + 2*x1 + 7*x2 + 11*x3 + x4 + 5*x5 <= 157)
m.addConstr(5*x0 + 10*x1 + 9*x2 + 3*x3 + 7*x4 + 3*x5 <= 384)
m.addConstr(7*x2**2 + x4**2 >= 11)
m.addConstr(2*x1 + 7*x2 >= 16)
m.addConstr(5*x0 + 2*x1 >= 8)
m.addConstr(4*x1**2 + 121*x3**2 >= 26)
m.addConstr(7*x2 + 11*x3 >= 18)
m.addConstr(25*x0**2 + x4**2 >= 10)
m.addConstr(7*x2 + 5*x5 >= 23)
m.addConstr(2*x1 + 7*x2 + 11*x3 >= 25)
m.addConstr(25*x0**2 + 4*x1**2 + 121*x3**2 >= 25)
m.addConstr(2*x1 + 7*x2 + 11*x3 >= 23)
m.addConstr(5*x0 + 2*x1 + 11*x3 >= 23)
m.addConstr(5*x0 + 2*x1 + 7*x2 + 11*x3 + x4 + 5*x5 >= 23)
m.addConstr(10*x1 + 3*x3 >= 38)
m.addConstr(10*x1 + 7*x4 >= 36)
m.addConstr(7*x4 + 3*x5 >= 30)
m.addConstr(9*x3**2 + 9*x5**2 >= 47)
m.addConstr(5*x0 + 10*x1 + 9*x2 + 3*x3 + 7*x4 + 3*x5 >= 47)
m.addConstr(-6*x1 + 7*x5 >= 0)
m.addConstr(25*x0**2 + 121*x3**2 <= 155)
m.addConstr(10*x1 + 3*x3 + 7*x4 <= 368)
m.addConstr(5*x0 + 9*x2 + 3*x5 <= 92)
m.addConstr(100*x1**2 + 9*x3**2 + 9*x5**2 <= 249)
m.addConstr(5*x0 + x4 + 3*x5 <= 117)
m.addConstr(10*x1 + 9*x2 + 3*x3 <= 298)
m.addConstr(25*x0**2 + 9*x3**2 + x4**2 <= 298)
m.addConstr(5*x0 + 10*x1 + 3*x5 <= 315)
m.addConstr(5*x0 + 10*x1 + 9*x2 <= 135)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Apples: ", x0.varValue)
    print("Black Beans: ", x1.varValue)
    print("Steaks: ", x2.varValue)
    print("Protein Bars: ", x3.varValue)
    print("Strips of Bacon: ", x4.varValue)
    print("Fruit Salads: ", x5.varValue)
else:
    print("No solution found")
