
import gurobipy as gp

# Create a new model
model = gp.Model("Productivity Optimization")

# Create variables
bill = model.addVar(vtype=gp.GRB.CONTINUOUS, name="bill")
mary = model.addVar(vtype=gp.GRB.CONTINUOUS, name="mary")
dale = model.addVar(vtype=gp.GRB.CONTINUOUS, name="dale")
john = model.addVar(vtype=gp.GRB.CONTINUOUS, name="john")
jean = model.addVar(vtype=gp.GRB.CONTINUOUS, name="jean")
paul = model.addVar(vtype=gp.GRB.CONTINUOUS, name="paul")

# Set objective function
model.setObjective(9.2 * bill + 4.25 * mary + 6.62 * dale + 4.22 * john + 8.6 * jean + 9.09 * paul, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(17 * dale + 3 * john >= 41)
model.addConstr(20 * bill + 20 * jean >= 46)
model.addConstr(20 * bill + 3 * john >= 47)
model.addConstr(14 * mary + 12 * paul >= 47)
model.addConstr(14 * mary + 20 * jean >= 62)
model.addConstr(17 * dale + 20 * jean >= 35)
model.addConstr(14 * mary + 17 * dale >= 48)
model.addConstr(20 * jean + 12 * paul >= 28)
model.addConstr(3 * john + 12 * paul >= 66)
model.addConstr(20 * bill + 14 * mary + 17 * dale + 3 * john + 20 * jean + 12 * paul >= 66)
model.addConstr(-9 * john + 10 * jean >= 0)
model.addConstr(-10 * mary + 7 * paul >= 0)
model.addConstr(7 * dale - jean >= 0)
model.addConstr(-8 * mary + 3 * john >= 0)
model.addConstr(17 * dale + 3 * john <= 190)
model.addConstr(17 * dale + 20 * jean <= 409)
model.addConstr(20 * bill + 20 * jean <= 130)
model.addConstr(3 * john + 12 * paul <= 336)
model.addConstr(20 * bill + 17 * dale <= 138)
model.addConstr(17 * dale + 12 * paul <= 182)
model.addConstr(20 * jean + 12 * paul <= 222)
model.addConstr(20 * bill + 3 * john <= 320)
model.addConstr(14 * mary + 17 * dale <= 276)
model.addConstr(14 * mary + 3 * john <= 440)
model.addConstr(20 * bill + 12 * paul <= 365)
model.addConstr(3 * john + 20 * jean <= 171)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

