
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name='x1', lb=0)  # hours worked by Bill
x2 = m.addVar(name='x2', lb=0)  # hours worked by Mary
x3 = m.addVar(name='x3', lb=0)  # hours worked by Dale
x4 = m.addVar(name='x4', lb=0)  # hours worked by John
x5 = m.addVar(name='x5', lb=0)  # hours worked by Jean
x6 = m.addVar(name='x6', lb=0)  # hours worked by Paul

# Define the objective function
m.setObjective(9.2*x1 + 4.25*x2 + 6.62*x3 + 4.22*x4 + 8.6*x5 + 9.09*x6, gurobi.GRB.MINIMIZE)

# Add constraints
m.addConstr(17*x3 + 3*x4 >= 41)
m.addConstr(20*x1 + 20*x5 >= 46)
m.addConstr(20*x1 + 3*x4 >= 47)
m.addConstr(14*x2 + 12*x6 >= 47)
m.addConstr(14*x2 + 20*x5 >= 62)
m.addConstr(17*x3 + 20*x5 >= 35)
m.addConstr(14*x2 + 17*x3 >= 48)
m.addConstr(20*x5 + 12*x6 >= 28)
m.addConstr(3*x4 + 12*x6 >= 66)
m.addConstr(20*x1 + 14*x2 + 17*x3 + 3*x4 + 20*x5 + 12*x6 >= 66)
m.addConstr(-9*x4 + 10*x5 >= 0)
m.addConstr(-10*x2 + 7*x6 >= 0)
m.addConstr(7*x3 - x5 >= 0)
m.addConstr(-8*x2 + 3*x4 >= 0)
m.addConstr(17*x3 + 3*x4 <= 190)
m.addConstr(17*x3 + 20*x5 <= 409)
m.addConstr(20*x1 + 20*x5 <= 130)
m.addConstr(3*x4 + 12*x6 <= 336)
m.addConstr(20*x1 + 17*x3 <= 138)
m.addConstr(17*x3 + 12*x6 <= 182)
m.addConstr(20*x5 + 12*x6 <= 222)
m.addConstr(20*x1 + 3*x4 <= 320)
m.addConstr(14*x2 + 17*x3 <= 276)
m.addConstr(14*x2 + 3*x4 <= 440)
m.addConstr(20*x1 + 12*x6 <= 365)
m.addConstr(3*x4 + 20*x5 <= 171)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.Status.OPTIMAL:
    print('Objective: ', m.objval)
    print('x1: ', x1.varValue)
    print('x2: ', x2.varValue)
    print('x3: ', x3.varValue)
    print('x4: ', x4.varValue)
    print('x5: ', x5.varValue)
    print('x6: ', x6.varValue)
else:
    print('No solution found')
