
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
green_beans = m.addVar(lb=0, name="green_beans")
kale_salads = m.addVar(lb=0, name="kale_salads")
cheeseburgers = m.addVar(lb=0, name="cheeseburgers")
cantaloupes = m.addVar(lb=0, name="cantaloupes")

# Set objective function
m.setObjective(4 * green_beans + 8 * kale_salads + 1 * cheeseburgers + 9 * cantaloupes, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(10.3 * kale_salads + 8.25 * cantaloupes >= 27)
m.addConstr(2.82 * green_beans + 8.25 * cantaloupes >= 36)
m.addConstr(2.82 * green_beans + 10.3 * kale_salads >= 28)
m.addConstr(2.82 * green_beans + 10.32 * cheeseburgers >= 29)
m.addConstr(10.3 * kale_salads + 10.32 * cheeseburgers >= 24)
m.addConstr(2.82 * green_beans + 10.3 * kale_salads + 10.32 * cheeseburgers >= 20)
m.addConstr(2.82 * green_beans + 10.3 * kale_salads + 8.25 * cantaloupes >= 20)
m.addConstr(2.82 * green_beans + 10.3 * kale_salads + 10.32 * cheeseburgers >= 36)
m.addConstr(2.82 * green_beans + 10.3 * kale_salads + 8.25 * cantaloupes >= 36)
m.addConstr(2.82 * green_beans + 10.3 * kale_salads + 10.32 * cheeseburgers + 8.25 * cantaloupes >= 36)
m.addConstr(9.43 * green_beans + 9.56 * cantaloupes >= 38)
m.addConstr(1.61 * kale_salads + 9.62 * cheeseburgers >= 19)
m.addConstr(1.61 * kale_salads + 9.56 * cantaloupes >= 25)
m.addConstr(9.43 * green_beans + 1.61 * kale_salads + 9.56 * cantaloupes >= 26)
m.addConstr(9.43 * green_beans + 9.62 * cheeseburgers + 9.56 * cantaloupes >= 26)
m.addConstr(9.43 * green_beans + 1.61 * kale_salads + 9.62 * cheeseburgers >= 26)
m.addConstr(1.61 * kale_salads + 9.62 * cheeseburgers + 9.56 * cantaloupes >= 26)
m.addConstr(9.43 * green_beans + 1.61 * kale_salads + 9.56 * cantaloupes >= 24) 
m.addConstr(9.43 * green_beans + 9.62 * cheeseburgers + 9.56 * cantaloupes >= 24)
m.addConstr(9.43 * green_beans + 1.61 * kale_salads + 9.62 * cheeseburgers >= 24)
m.addConstr(1.61 * kale_salads + 9.62 * cheeseburgers + 9.56 * cantaloupes >= 24)
m.addConstr(9.43 * green_beans + 1.61 * kale_salads + 9.56 * cantaloupes >= 39)
m.addConstr(9.43 * green_beans + 9.62 * cheeseburgers + 9.56 * cantaloupes >= 39)
m.addConstr(9.43 * green_beans + 1.61 * kale_salads + 9.62 * cheeseburgers >= 39)
m.addConstr(1.61 * kale_salads + 9.62 * cheeseburgers + 9.56 * cantaloupes >= 39)
m.addConstr(9.43 * green_beans + 1.61 * kale_salads + 9.56 * cantaloupes >= 38)
m.addConstr(9.43 * green_beans + 9.62 * cheeseburgers + 9.56 * cantaloupes >= 38)
m.addConstr(9.43 * green_beans + 1.61 * kale_salads + 9.62 * cheeseburgers >= 38)
m.addConstr(1.61 * kale_salads + 9.62 * cheeseburgers + 9.56 * cantaloupes >= 38)
m.addConstr(9.43 * green_beans + 1.61 * kale_salads + 9.62 * cheeseburgers + 9.56 * cantaloupes >= 38)
m.addConstr(2.82 * green_beans + 10.3 * kale_salads + 10.32 * cheeseburgers <= 135)
m.addConstr(9.43 * green_beans + 9.56 * cantaloupes <= 147)
m.addConstr(1.61 * kale_salads + 9.56 * cantaloupes <= 65)
m.addConstr(9.43 * green_beans + 1.61 * kale_salads <= 151)
m.addConstr(1.61 * kale_salads + 9.62 * cheeseburgers <= 46)
m.addConstr(9.62 * cheeseburgers + 9.56 * cantaloupes <= 112)
m.addConstr(9.43 * green_beans + 9.62 * cheeseburgers <= 74)
m.addConstr(9.43 * green_beans + 1.61 * kale_salads + 9.62 * cheeseburgers <= 129)
m.addConstr(1.61 * kale_salads + 9.62 * cheeseburgers + 9.56 * cantaloupes <= 89)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

