
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.INTEGER, name="hours worked by George")
    x1 = model.addVar(vtype=gp.GRB.INTEGER, name="hours worked by Bill")


    # Set objective function
    model.setObjective(1.69 * x0 + 5.4 * x1, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(14 * x0 + 2 * x1 >= 63, "c0")
    model.addConstr(1 * x0 + 12 * x1 >= 31, "c1")
    model.addConstr(4 * x0 + 13 * x1 >= 24, "c2")
    model.addConstr(6 * x0 + 13 * x1 >= 56, "c3")
    model.addConstr(-6 * x0 + 9 * x1 >= 0, "c4")
    model.addConstr(14 * x0 + 2 * x1 <= 77, "c5")
    model.addConstr(1 * x0 + 12 * x1 <= 65, "c6")
    model.addConstr(4 * x0 + 13 * x1 <= 37, "c7")
    model.addConstr(6 * x0 + 13 * x1 <= 115, "c8")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
