
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_George")
x2 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Bill")

# Set the objective function
m.setObjective(1.69*x1 + 5.4*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(14*x1 + 2*x2 >= 63, "productivity_rating")
m.addConstr(1*x1 + 12*x2 >= 31, "likelihood_to_quit_index_min")
m.addConstr(4*x1 + 13*x2 >= 24, "organization_score_min")
m.addConstr(6*x1 + 13*x2 >= 56, "computer_competence_rating_min")
m.addConstr(-6*x1 + 9*x2 >= 0, "mixed_constraint")
m.addConstr(14*x1 + 2*x2 <= 77, "productivity_rating_max")
m.addConstr(1*x1 + 12*x2 <= 65, "likelihood_to_quit_index_max")
m.addConstr(4*x1 + 13*x2 <= 37, "organization_score_max")
m.addConstr(6*x1 + 13*x2 <= 115, "computer_competence_rating_max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by George: {x1.x}")
    print(f"Hours worked by Bill: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
