
import gurobi as gp

# Create a new model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="hours_worked_by_George", vtype=gp.GRB.INTEGER)
x1 = m.addVar(name="hours_worked_by_Bill", vtype=gp.GRB.INTEGER)

# Objective function
m.setObjective(1.69 * x0 + 5.4 * x1, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(14 * x0 + 2 * x1 >= 63, name="productivity_rating")
m.addConstr(x0 + 12 * x1 >= 31, name="likelihood_to_quit_index")
m.addConstr(4 * x0 + 13 * x1 >= 24, name="organization_score")
m.addConstr(6 * x0 + 13 * x1 >= 56, name="computer_competence_rating")
m.addConstr(-6 * x0 + 9 * x1 >= 0, name="combined_productivity")
m.addConstr(14 * x0 + 2 * x1 <= 77, name="max_productivity_rating")
m.addConstr(x0 + 12 * x1 <= 65, name="max_likelihood_to_quit_index")
m.addConstr(4 * x0 + 13 * x1 <= 37, name="max_organization_score")
m.addConstr(6 * x0 + 13 * x1 <= 115, name="max_computer_competence_rating")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Hours worked by George: ", x0.varValue)
    print("Hours worked by Bill: ", x1.varValue)
    print("Objective: ", m.objVal)
else:
    print("The model is infeasible")
