
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x0") # hours worked by Peggy
    x1 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x1") # hours worked by Bill


    # Set objective function
    model.setObjective(2*x0 + 3*x1, GRB.MINIMIZE)

    # Add constraints
    model.addConstr(6*x0 + 6*x1 >= 63, "c0")
    model.addConstr(14*x0 + 6*x1 >= 34, "c1")
    model.addConstr(9*x0 + 15*x1 >= 50, "c2")
    model.addConstr(5*x0 - 9*x1 >= 0, "c3")
    model.addConstr(6*x0 + 6*x1 <= 132, "c4")
    model.addConstr(14*x0 + 6*x1 <= 159, "c5")
    model.addConstr(9*x0 + 15*x1 <= 151, "c6")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal objective value:", model.objVal)
        print("x0 (hours worked by Peggy):", x0.x)
        print("x1 (hours worked by Bill):", x1.x)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
