
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Create variables
x1 = m.addVar(lb=0, name="hours_worked_by_Peggy")
x2 = m.addVar(lb=0, name="hours_worked_by_Bill")

# Set the objective function
m.setObjective(2*x1 + 3*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(6*x1 + 6*x2 >= 63, "dollar_cost_min")
m.addConstr(14*x1 + 6*x2 >= 34, "paperwork_rating_min")
m.addConstr(9*x1 + 15*x2 >= 50, "computer_rating_min")
m.addConstr(5*x1 - 9*x2 >= 0, "mixed_constraint")
m.addConstr(6*x1 + 6*x2 <= 132, "dollar_cost_max")
m.addConstr(14*x1 + 6*x2 <= 159, "paperwork_rating_max")
m.addConstr(9*x1 + 15*x2 <= 151, "computer_rating_max")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Peggy: {x1.x}")
    print(f"Hours worked by Bill: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
