
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='hours_worked_by_Peggy', lb=0)  # Assuming hours cannot be negative
    x2 = model.addVar(name='hours_worked_by_Bill', lb=0)  # Assuming hours cannot be negative

    # Define the objective function
    model.setObjective(2 * x1 + 3 * x2, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(6 * x1 + 6 * x2 >= 63)
    model.addConstr(14 * x1 + 6 * x2 >= 34)
    model.addConstr(9 * x1 + 15 * x2 >= 50)
    model.addConstr(5 * x1 - 9 * x2 >= 0)
    model.addConstr(6 * x1 + 6 * x2 <= 132)
    model.addConstr(14 * x1 + 6 * x2 <= 159)
    model.addConstr(9 * x1 + 15 * x2 <= 151)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal solution found.')
        print(f'Hours worked by Peggy: {x1.varValue}')
        print(f'Hours worked by Bill: {x2.varValue}')
        print(f'Objective function value: {model.objVal}')
    else:
        print('No optimal solution found.')

solve_optimization_problem()
