
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("digestive_support")

    # Create variables
    fiber = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="fiber")
    potassium = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="potassium")
    magnesium = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="magnesium")


    # Set objective function
    m.setObjective(7*fiber + 8*potassium + magnesium, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(4*potassium + 15*magnesium >= 24, "c1")
    m.addConstr(8*fiber + 15*magnesium >= 25, "c2")
    m.addConstr(8*fiber + 4*potassium >= 14, "c3")
    m.addConstr(8*fiber + 4*potassium + 15*magnesium >= 14, "c4")
    m.addConstr(-3*potassium + 2*magnesium >= 0, "c5")
    m.addConstr(-9*fiber + 6*potassium >= 0, "c6")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == GRB.OPTIMAL:
        print(f"Optimal objective value: {m.objVal}")
        print(f"Grams of Fiber: {fiber.x}")
        print(f"Milligrams of Potassium: {potassium.x}")
        print(f"Milligrams of Magnesium: {magnesium.x}")
    elif m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
