
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="grams_of_fiber")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_potassium")
x3 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_magnesium")

# Define the objective function
m.setObjective(7*x1 + 8*x2 + x3, GRB.MINIMIZE)

# Add constraints
m.addConstr(4*x2 + 15*x3 >= 24, "digestive_support_index_1")
m.addConstr(8*x1 + 15*x3 >= 25, "digestive_support_index_2")
m.addConstr(8*x1 + 4*x2 >= 14, "digestive_support_index_3")
m.addConstr(8*x1 + 4*x2 + 15*x3 >= 14, "total_digestive_support_index")
m.addConstr(-3*x2 + 2*x3 >= 0, "potassium_magnesium_ratio")
m.addConstr(-9*x1 + 6*x2 >= 0, "fiber_potassium_ratio")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Grams of Fiber: {x1.x}")
    print(f"Milligrams of Potassium: {x2.x}")
    print(f"Milligrams of Magnesium: {x3.x}")
else:
    print("No optimal solution found")
