
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(name="grams_of_fiber", lb=0)  # You may use a fractional amount
    x2 = model.addVar(name="milligrams_of_potassium", lb=0)  # The quantity does not have to be a whole number
    x3 = model.addVar(name="milligrams_of_magnesium", lb=0)  # You may have a non-integer amount

    # Objective function
    model.setObjective(7 * x1 + 8 * x2 + x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(4 * x2 + 15 * x3 >= 24)
    model.addConstr(8 * x1 + 15 * x3 >= 25)
    model.addConstr(8 * x1 + 4 * x2 >= 14)
    model.addConstr(-3 * x2 + 2 * x3 >= 0)
    model.addConstr(-9 * x1 + 6 * x2 >= 0)

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Grams of fiber: {x1.varValue}")
        print(f"Milligrams of potassium: {x2.varValue}")
        print(f"Milligrams of magnesium: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
