
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
x0 = m.addVar(name="vitamin_B12")
x1 = m.addVar(name="magnesium")
x2 = m.addVar(name="vitamin_B9")
x3 = m.addVar(name="vitamin_K")


# Set objective function
m.setObjective(2.54*x0**2 + 6.57*x0*x1 + 1.16*x0*x2 + 2.7*x1**2 + 3.64*x1*x2 + 2.41*x1*x3 + 8.5*x2**2 + 3.38*x2*x3 + 5.71*x2 + 8.5*x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(16*x0 + 8*x1 + 8*x2 + 9*x3 <= 143, "c0")
m.addConstr(3*x0 + 11*x1 + 5*x2 + 16*x3 <= 288, "c1")
m.addConstr(8*x1 + 8*x2 >= 18, "c2")
m.addConstr(8*x2 + 9*x3 >= 29, "c3")
m.addConstr(16*x0 + 8*x1 >= 34, "c4")
m.addConstr((16*x0)**2 + (8*x2)**2 >= 32, "c5")
m.addConstr(3*x0 + 5*x2 >= 30, "c6")
m.addConstr(8*x1 + 9*x3 <= 100, "c7")
m.addConstr(16*x0 + 8*x1 <= 88, "c8")
m.addConstr(16*x0 + 8*x1 + 8*x2 + 9*x3 <= 88, "c9")
m.addConstr(3*x0 + 5*x2 <= 247, "c10")
m.addConstr((5*x2)**2 + (16*x3)**2 <= 265, "c11")
m.addConstr(11*x1 + 16*x3 <= 126, "c12")
m.addConstr((3*x0)**2 + (16*x3)**2 <= 184, "c13")
m.addConstr(3*x0 + 11*x1 + 5*x2 <= 278, "c14")
m.addConstr(3*x0 + 5*x2 + 16*x3 <= 174, "c15")
m.addConstr((3*x0)**2 + (11*x1)**2 + (16*x3)**2 <= 238, "c16")
m.addConstr(3*x0 + 11*x1 + 5*x2 + 16*x3 <= 238, "c17")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

