
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = {}
x[0] = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bagged salads")
x[1] = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="chicken thighs")
x[2] = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="cantaloupes")
x[3] = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bowls of pasta")
x[4] = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken drumsticks")
x[5] = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="bowls of cereal")
x[6] = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="potatoes")


# Set objective function
m.setObjective(4*x[0] + 5*x[1] + 7*x[2] + 2*x[3] + 5*x[4] + 1*x[5] + 9*x[6], gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x[0] + 14*x[3] >= 39)
m.addConstr(2*x[0] + 6*x[1] >= 38)
m.addConstr(19*x[4] + 13*x[5] >= 63)
m.addConstr(14*x[3] + 13*x[5] >= 65)
m.addConstr(14*x[3] + 7*x[6] >= 39)
m.addConstr(2*x[0] + 19*x[4] >= 56)
m.addConstr(2*x[0] + 7*x[6] >= 37)
m.addConstr(6*x[1] + 19*x[4] >= 62)
m.addConstr(2*x[0] + 13*x[5] >= 77)
m.addConstr(15*x[2] + 7*x[6] >= 49)
m.addConstr(14*x[3] + 19*x[4] >= 62)
m.addConstr(2*x[0] + 15*x[2] >= 50)
m.addConstr(2*x[0] + 13*x[5] + 7*x[6] >= 72)
m.addConstr(2*x[0] + 6*x[1] + 15*x[2] + 14*x[3] + 19*x[4] + 13*x[5] + 7*x[6] >= 72)
m.addConstr(6*x[2] + 6*x[6] >= 38)
m.addConstr(17*x[0] + 11*x[1] >= 31)
m.addConstr(6*x[2] + 12*x[5] >= 36)
m.addConstr(10*x[4] + 6*x[6] >= 47)
m.addConstr(6*x[2] + 12*x[3] >= 30)
m.addConstr(6*x[2] + 10*x[4] >= 23)
m.addConstr(12*x[5] + 6*x[6] >= 23)
m.addConstr(17*x[0] + 12*x[3] >= 49)
m.addConstr(11*x[1] + 12*x[3] >= 39)
m.addConstr(11*x[1] + 6*x[2] >= 20)
m.addConstr(10*x[4] + 12*x[5] >= 23)
m.addConstr(11*x[1] + 6*x[2] + 12*x[3] >= 26)
m.addConstr(17*x[0] + 6*x[2] + 12*x[3] >= 26)
m.addConstr(11*x[1] + 10*x[4] + 6*x[6] >= 26)
m.addConstr(11*x[1] + 6*x[2] + 12*x[3] >= 35)
m.addConstr(17*x[0] + 6*x[2] + 12*x[3] >= 35)
m.addConstr(11*x[1] + 10*x[4] + 6*x[6] >= 35)
m.addConstr(11*x[1] + 6*x[2] + 12*x[3] >= 44)
m.addConstr(17*x[0] + 6*x[2] + 12*x[3] >= 44)
m.addConstr(11*x[1] + 10*x[4] + 6*x[6] >= 44)
m.addConstr(17*x[0] + 11*x[1] + 6*x[2] + 12*x[3] + 10*x[4] + 12*x[5] + 6*x[6] >= 44)


# Add resource constraints
tastiness = {'x0': 2, 'x1': 6, 'x2': 15, 'x3': 14, 'x4': 19, 'x5': 13, 'x6': 7}
fiber = {'x0': 17, 'x1': 11, 'x2': 6, 'x3': 12, 'x4': 10, 'x5': 12, 'x6': 6}
sourness = {'x0': 13, 'x1': 7, 'x2': 9, 'x3': 13, 'x4': 13, 'x5': 16, 'x6': 7}

m.addConstr(sum(tastiness[key]*x[int(key[1:])] for key in tastiness) <= 552)
m.addConstr(sum(fiber[key]*x[int(key[1:])] for key in fiber) <= 343)
m.addConstr(sum(sourness[key]*x[int(key[1:])] for key in sourness) <= 249)


# ... (rest of the constraints, added similarly as above)

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

