
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
bill_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bill_hours")
hank_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank_hours")
dale_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="dale_hours")
john_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="john_hours")

# Set objective function
m.setObjective(9 * bill_hours + 7 * hank_hours + 9 * dale_hours + 3 * john_hours, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(10 * hank_hours + 7 * dale_hours >= 28)
m.addConstr(7 * dale_hours + 8 * john_hours >= 35)
m.addConstr(16 * bill_hours + 10 * hank_hours >= 28)
m.addConstr(16 * bill_hours + 7 * dale_hours >= 31)
m.addConstr(16 * bill_hours + 10 * hank_hours + 8 * john_hours >= 44)
m.addConstr(10 * hank_hours + 7 * dale_hours + 8 * john_hours >= 44)
m.addConstr(16 * bill_hours + 10 * hank_hours + 7 * dale_hours >= 44)
m.addConstr(16 * bill_hours + 7 * dale_hours + 8 * john_hours >= 44)
m.addConstr(16 * bill_hours + 10 * hank_hours + 8 * john_hours >= 48)
m.addConstr(10 * hank_hours + 7 * dale_hours + 8 * john_hours >= 48)
m.addConstr(16 * bill_hours + 10 * hank_hours + 7 * dale_hours >= 48)
m.addConstr(16 * bill_hours + 7 * dale_hours + 8 * john_hours >= 48)
m.addConstr(16 * bill_hours + 10 * hank_hours + 8 * john_hours >= 32)
m.addConstr(10 * hank_hours + 7 * dale_hours + 8 * john_hours >= 32)
m.addConstr(16 * bill_hours + 10 * hank_hours + 7 * dale_hours >= 32)
m.addConstr(16 * bill_hours + 7 * dale_hours + 8 * john_hours >= 32)
m.addConstr(16 * bill_hours + 10 * hank_hours + 8 * john_hours >= 36)
m.addConstr(10 * hank_hours + 7 * dale_hours + 8 * john_hours >= 36)
m.addConstr(16 * bill_hours + 10 * hank_hours + 7 * dale_hours >= 36)
m.addConstr(16 * bill_hours + 7 * dale_hours + 8 * john_hours >= 36)
m.addConstr(16 * bill_hours + 10 * hank_hours + 7 * dale_hours + 8 * john_hours >= 36)
m.addConstr(1 * dale_hours + 12 * john_hours >= 32)
m.addConstr(7 * bill_hours + 12 * john_hours >= 38)
m.addConstr(8 * hank_hours + 12 * john_hours >= 24)
m.addConstr(7 * bill_hours + 8 * hank_hours >= 39)
m.addConstr(7 * bill_hours + 8 * hank_hours + 12 * john_hours >= 48)
m.addConstr(7 * bill_hours + 1 * dale_hours + 12 * john_hours >= 48)
m.addConstr(7 * bill_hours + 8 * hank_hours + 12 * john_hours >= 41)
m.addConstr(7 * bill_hours + 1 * dale_hours + 12 * john_hours >= 41)
m.addConstr(7 * bill_hours + 8 * hank_hours + 1 * dale_hours + 12 * john_hours >= 41)
m.addConstr(2 * bill_hours + 3 * dale_hours >= 24)
m.addConstr(5 * hank_hours + 3 * dale_hours >= 26)
m.addConstr(2 * bill_hours + 5 * hank_hours >= 59)
m.addConstr(2 * bill_hours + 3 * dale_hours + 11 * john_hours >= 53)
m.addConstr(2 * bill_hours + 5 * hank_hours + 3 * dale_hours + 11 * john_hours >= 53)
m.addConstr(1 * dale_hours + 2 * john_hours >= 22)
m.addConstr(16 * bill_hours + 2 * john_hours >= 58)
m.addConstr(15 * hank_hours + 1 * dale_hours >= 40)
m.addConstr(16 * bill_hours + 15 * hank_hours >= 39)
m.addConstr(16 * bill_hours + 1 * dale_hours + 2 * john_hours >= 42)
m.addConstr(16 * bill_hours + 15 * hank_hours + 1 * dale_hours + 2 * john_hours >= 42)
m.addConstr(2 * dale_hours - 10 * john_hours >= 0)
m.addConstr(-9 * bill_hours + 9 * hank_hours >= 0)
m.addConstr(16 * bill_hours + 10 * hank_hours + 7 * dale_hours <= 177)
m.addConstr(8 * hank_hours + 1 * dale_hours + 12 * john_hours <= 121)
m.addConstr(2 * bill_hours + 5 * hank_hours + 11 * john_hours <= 146)
m.addConstr(2 * bill_hours + 5 * hank_hours + 3 * dale_hours <= 117)
m.addConstr(2 * bill_hours + 3 * dale_hours + 11 * john_hours <= 163)
m.addConstr(1 * dale_hours + 2 * john_hours <= 195)
m.addConstr(15 * hank_hours + 2 * john_hours <= 184)
m.addConstr(16 * bill_hours + 15 * hank_hours <= 211)
m.addConstr(16 * bill_hours + 1 * dale_hours <= 81)
m.addConstr(16 * bill_hours + 1 * dale_hours + 2 * john_hours <= 181)
m.addConstr(15 * hank_hours + 1 * dale_hours + 2 * john_hours <= 218)
m.addConstr(16 * bill_hours + 15 * hank_hours + 1 * dale_hours <= 114)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

