
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
chicken_breasts = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_breasts")
kale_salads = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="kale_salads")
cherry_pies = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cherry_pies")
blueberry_pies = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="blueberry_pies")


# Set objective function
m.setObjective(3.85 * chicken_breasts + 4.14 * kale_salads + 9.8 * cherry_pies + 3.1 * blueberry_pies, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(chicken_breasts + 10 * kale_salads >= 13)
m.addConstr(10 * kale_salads + 10 * blueberry_pies >= 18)
m.addConstr(3 * cherry_pies + 10 * blueberry_pies >= 9)
m.addConstr(chicken_breasts + 3 * cherry_pies >= 27)
m.addConstr(chicken_breasts + 10 * kale_salads + 3 * cherry_pies >= 23)
m.addConstr(10 * kale_salads + 3 * cherry_pies + 10 * blueberry_pies >= 23)
m.addConstr(chicken_breasts + 10 * kale_salads + 3 * cherry_pies >= 26)
m.addConstr(10 * kale_salads + 3 * cherry_pies + 10 * blueberry_pies >= 26)
m.addConstr(chicken_breasts + 10 * kale_salads + 3 * cherry_pies + 10 * blueberry_pies >= 26)
m.addConstr(8 * kale_salads + 6 * blueberry_pies >= 26)
m.addConstr(8 * chicken_breasts + 7 * cherry_pies >= 26)
m.addConstr(7 * cherry_pies + 6 * blueberry_pies >= 26)
m.addConstr(8 * chicken_breasts + 6 * blueberry_pies >= 20)
m.addConstr(8 * chicken_breasts + 8 * kale_salads + 7 * cherry_pies + 6 * blueberry_pies >= 20)
m.addConstr(10 * kale_salads + 6 * cherry_pies >= 20)
m.addConstr(7 * chicken_breasts + 6 * cherry_pies >= 33)
m.addConstr(6 * cherry_pies + 9 * blueberry_pies >= 31)
m.addConstr(7 * chicken_breasts + 9 * blueberry_pies >= 28)
m.addConstr(7 * chicken_breasts + 10 * kale_salads >= 22)
m.addConstr(7 * chicken_breasts + 6 * cherry_pies + 9 * blueberry_pies >= 19)
m.addConstr(7 * chicken_breasts + 10 * kale_salads + 6 * cherry_pies + 9 * blueberry_pies >= 19)
m.addConstr(2 * chicken_breasts - 2 * blueberry_pies >= 0)
m.addConstr(10 * kale_salads - 5 * cherry_pies >= 0)
m.addConstr(chicken_breasts + 10 * kale_salads <= 65)
m.addConstr(3 * cherry_pies + 10 * blueberry_pies <= 45)
m.addConstr(10 * kale_salads + 10 * blueberry_pies <= 91)
m.addConstr(10 * kale_salads + 3 * cherry_pies + 10 * blueberry_pies <= 104)
m.addConstr(chicken_breasts + 10 * kale_salads + 10 * blueberry_pies <= 104)
m.addConstr(8 * chicken_breasts + 7 * cherry_pies <= 125)
m.addConstr(7 * cherry_pies + 6 * blueberry_pies <= 78)
m.addConstr(7 * chicken_breasts + 9 * blueberry_pies <= 60)
m.addConstr(7 * chicken_breasts + 10 * kale_salads + 9 * blueberry_pies <= 67)


m.addConstr(chicken_breasts <= 110)
m.addConstr(10*kale_salads <= 110)
m.addConstr(3*cherry_pies <= 110)
m.addConstr(10*blueberry_pies <= 110)

m.addConstr(8*chicken_breasts <= 169)
m.addConstr(8*kale_salads <= 169)
m.addConstr(7*cherry_pies <= 169)
m.addConstr(6*blueberry_pies <= 169)

m.addConstr(7*chicken_breasts <= 145)
m.addConstr(10*kale_salads <= 145)
m.addConstr(6*cherry_pies <= 145)
m.addConstr(9*blueberry_pies <= 145)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

