
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="chicken breasts", lb=0)
    x1 = model.addVar(name="kale salads", lb=0)
    x2 = model.addVar(name="cherry pies", lb=0)
    x3 = model.addVar(name="blueberry pies", lb=0)

    # Objective function
    model.setObjective(3.85 * x0 + 4.14 * x1 + 9.8 * x2 + 3.1 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(x0 + 10 * x1 + 3 * x2 + 10 * x3 <= 110)
    model.addConstr(8 * x0 + 8 * x1 + 7 * x2 + 6 * x3 <= 169)
    model.addConstr(7 * x0 + 10 * x1 + 6 * x2 + 9 * x3 <= 145)
    model.addConstr(x0 + 10 * x1 >= 13)
    model.addConstr(10 * x1 + 10 * x3 >= 18)
    model.addConstr(3 * x2 + 10 * x3 >= 9)
    model.addConstr(x0 + 3 * x2 >= 27)
    model.addConstr(x0 + 10 * x1 + 3 * x2 >= 23)
    model.addConstr(10 * x1 + 3 * x2 + 10 * x3 >= 23)
    model.addConstr(x0 + 10 * x1 + 3 * x2 >= 26)
    model.addConstr(10 * x1 + 3 * x2 + 10 * x3 >= 26)
    model.addConstr(x0 + 10 * x1 + 3 * x2 + 10 * x3 >= 26)
    model.addConstr(8 * x1 + 6 * x3 >= 26)
    model.addConstr(8 * x0 + 7 * x2 >= 26)
    model.addConstr(7 * x2 + 6 * x3 >= 26)
    model.addConstr(8 * x0 + 6 * x3 >= 20)
    model.addConstr(8 * x0 + 8 * x1 + 7 * x2 + 6 * x3 >= 20)
    model.addConstr(10 * x1 + 6 * x2 >= 20)
    model.addConstr(7 * x0 + 6 * x2 >= 33)
    model.addConstr(6 * x2 + 9 * x3 >= 31)
    model.addConstr(7 * x0 + 9 * x3 >= 28)
    model.addConstr(7 * x0 + 10 * x1 >= 22)
    model.addConstr(7 * x0 + 6 * x2 + 9 * x3 >= 19)
    model.addConstr(7 * x0 + 10 * x1 + 6 * x2 + 9 * x3 >= 19)
    model.addConstr(2 * x0 - 2 * x3 >= 0)
    model.addConstr(10 * x1 - 5 * x2 >= 0)
    model.addConstr(x0 + 10 * x1 <= 65)
    model.addConstr(3 * x2 + 10 * x3 <= 45)
    model.addConstr(10 * x1 + 10 * x3 <= 91)
    model.addConstr(10 * x1 + 3 * x2 + 10 * x3 <= 104)
    model.addConstr(x0 + 10 * x1 + 10 * x3 <= 104)
    model.addConstr(8 * x0 + 7 * x2 <= 125)
    model.addConstr(7 * x2 + 6 * x3 <= 78)
    model.addConstr(7 * x0 + 9 * x3 <= 60)
    model.addConstr(7 * x0 + 10 * x1 + 9 * x3 <= 67)

    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Chicken breasts: ", x0.varValue)
        print("Kale salads: ", x1.varValue)
        print("Cherry pies: ", x2.varValue)
        print("Blueberry pies: ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
