
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name='x0', vtype='I')  # integer
x1 = model.addVar(name='x1')  # continuous
x2 = model.addVar(name='x2')  # continuous

# Set the objective function
model.setObjective(2.14 * x0 + 7.59 * x1 + 8.12 * x2, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(13 * x0 + 10 * x1 + 5 * x2 >= 61)
model.addConstr(23 * x0 + 6 * x1 >= 27)
model.addConstr(23 * x0 + 6 * x1 + 7 * x2 >= 31)
model.addConstr(19 * x1 + 13 * x2 <= 91)
model.addConstr(14 * x0 + 19 * x1 <= 136)
model.addConstr(14 * x0 + 19 * x1 + 13 * x2 <= 136)
model.addConstr(10 * x1 + 5 * x2 <= 133)
model.addConstr(13 * x0 + 5 * x2 <= 169)
model.addConstr(13 * x0 + 10 * x1 <= 81)
model.addConstr(13 * x0 + 10 * x1 + 5 * x2 <= 173)
model.addConstr(6 * x1 + 7 * x2 <= 90)
model.addConstr(23 * x0 + 6 * x1 <= 177)
model.addConstr(23 * x0 + 6 * x1 + 7 * x2 <= 177)
model.addConstr(7 * x0 + 16 * x2 <= 98)
model.addConstr(7 * x0 + 14 * x1 + 16 * x2 <= 98)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', model.objval)
    print('x0: ', x0.varValue)
    print('x1: ', x1.varValue)
    print('x2: ', x2.varValue)
else:
    print('The model is infeasible')
