
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x = m.addVars(4, vtype=gp.GRB.INTEGER, name=["George", "Bobby", "Mary", "Laura"])


    # Set objective function
    obj = 5.34*x[0]*x[1] + 8.25*x[0]*x[3] + 6.41*x[1]**2 + 5.17*x[1]*x[2] + 1.46*x[1]*x[3] + 8.61*x[2]*x[3] + 6.63*x[3]**2 + 3.9*x[0] + 2.32*x[1] + 8.68*x[3]
    m.setObjective(obj, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(12*x[0] + 13*x[3] >= 54)
    m.addConstr(15*x[0] + 6*x[2] >= 89)
    m.addConstr(15*x[0]**2 + 6*x[2]**2 + 13*x[3]**2 >= 73)
    m.addConstr(6*x[1] + 6*x[2] + 13*x[3] >= 73)
    m.addConstr(15*x[0] + 6*x[1] + 6*x[2] >= 73)
    m.addConstr(15*x[0] + 6*x[2] + 13*x[3] >= 87)
    m.addConstr(6*x[1]**2 + 6*x[2]**2 + 13*x[3]**2 >= 87)
    m.addConstr(15*x[0] + 6*x[1] + 6*x[2] >= 87)
    m.addConstr(15*x[0] + 6*x[2] + 13*x[3] >= 79)
    m.addConstr(6*x[1] + 6*x[2] + 13*x[3] >= 79)
    m.addConstr(15*x[0] + 6*x[1] + 6*x[2] >= 79)
    m.addConstr(13*x[2]**2 + 13*x[3]**2 <= 199)
    m.addConstr(12*x[0]**2 + 13*x[1]**2 <= 438)
    m.addConstr(13*x[1]**2 + 13*x[3]**2 <= 162)
    m.addConstr(12*x[0] + 13*x[3] <= 462)
    m.addConstr(12*x[0] + 13*x[1] + 13*x[2] <= 411)
    m.addConstr(13*x[1] + 13*x[2] + 13*x[3] <= 246)
    m.addConstr(12*x[0] + 13*x[1] + 13*x[2] + 13*x[3] <= 246)
    m.addConstr(6*x[2]**2 + 13*x[3]**2 <= 328)
    m.addConstr(15*x[0] + 13*x[3] <= 470)
    m.addConstr(15*x[0]**2 + 6*x[1]**2 <= 530)
    m.addConstr(15*x[0] + 6*x[1] + 6*x[2] + 13*x[3] <= 530)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print(f'{v.varName}: {v.x}')
        print(f'Obj: {m.objVal}')
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
