
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x = m.addVars(5, lb=0, vtype=gp.GRB.CONTINUOUS, names=["x0", "x1", "x2", "x3", "x4"])


    # Set objective function
    m.setObjective(7*x[0] + 6*x[1] + 7*x[2] + 9*x[3] + 6*x[4], gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(8.51*x[0] + 2.48*x[1] >= 47)
    m.addConstr(6.81*x[2] + 4.66*x[4] >= 48)
    m.addConstr(2.48*x[1] + 8.54*x[3] >= 17)
    m.addConstr(2.48*x[1] + 4.66*x[4] >= 52)
    m.addConstr(8.51*x[0] + 4.66*x[4] >= 49)
    m.addConstr(8.51*x[0] + 2.48*x[1] + 6.81*x[2] + 8.54*x[3] + 4.66*x[4] >= 49)
    m.addConstr(6.29*x[0] + 4.54*x[4] >= 52)
    m.addConstr(7.02*x[1] + 5.27*x[3] >= 47)
    m.addConstr(7.02*x[1] + 4.54*x[4] >= 22)
    m.addConstr(7.02*x[1] + 3.93*x[2] >= 57)
    m.addConstr(6.29*x[0] + 3.93*x[2] >= 62)
    m.addConstr(3.93*x[2] + 5.27*x[3] + 4.54*x[4] >= 42)
    m.addConstr(7.02*x[1] + 3.93*x[2] + 4.54*x[4] >= 42)
    m.addConstr(7.02*x[1] + 3.93*x[2] + 5.27*x[3] >= 42)
    m.addConstr(3.93*x[2] + 5.27*x[3] + 4.54*x[4] >= 56)
    m.addConstr(7.02*x[1] + 3.93*x[2] + 4.54*x[4] >= 56)
    m.addConstr(7.02*x[1] + 3.93*x[2] + 5.27*x[3] >= 56)
    m.addConstr(6.29*x[0] + 7.02*x[1] + 3.93*x[2] + 5.27*x[3] + 4.54*x[4] >= 56)
    m.addConstr(-x[2] + 9*x[4] >= 0)
    m.addConstr(8*x[2] - 8*x[3] >= 0)
    m.addConstr(6.81*x[2] + 4.66*x[4] <= 192)
    m.addConstr(8.54*x[3] + 4.66*x[4] <= 146)
    m.addConstr(2.48*x[1] + 8.54*x[3] <= 75)
    m.addConstr(2.48*x[1] + 6.81*x[2] + 8.54*x[3] <= 172)
    m.addConstr(8.51*x[0] + 2.48*x[1] + 8.54*x[3] <= 107)
    m.addConstr(8.51*x[0] + 2.48*x[1] + 4.66*x[4] <= 210)
    m.addConstr(8.51*x[0] + 8.54*x[3] + 4.66*x[4] <= 91)
    m.addConstr(8.51*x[0] + 2.48*x[1] + 6.81*x[2] <= 133)
    m.addConstr(2.48*x[1] + 6.81*x[2] + 4.66*x[4] <= 240)
    m.addConstr(6.81*x[2] + 8.54*x[3] + 4.66*x[4] <= 57)
    m.addConstr(7.02*x[1] + 3.93*x[2] <= 229)
    m.addConstr(6.29*x[0] + 3.93*x[2] <= 315)
    m.addConstr(3.93*x[2] + 5.27*x[3] <= 314)
    m.addConstr(5.27*x[3] + 4.54*x[4] <= 323)



    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print(f'{v.varName}: {v.x}')
        print(f'Obj: {m.objVal}')
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GrorbiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
