
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("growth_optimization")

# Create variables
coleus = m.addVar(vtype=GRB.INTEGER, name="coleus")
roses = m.addVar(vtype=GRB.INTEGER, name="roses")

# Set objective function
m.setObjective(2 * coleus + 9 * roses, GRB.MINIMIZE)

# Add constraints
m.addConstr(0.82 * coleus + 1.29 * roses >= 43, "growth_min")
m.addConstr(-8 * coleus + 8 * roses >= 0, "coleus_roses_ratio")
m.addConstr(0.82 * coleus + 1.29 * roses <= 117, "growth_max")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal solution:")
    print(f"  coleus: {coleus.x}")
    print(f"  roses: {roses.x}")
    print(f"  Objective value: {m.objVal}")

