
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="coleus")
x2 = m.addVar(vtype=GRB.INTEGER, name="roses")

# Set the objective function
m.setObjective(2*x1 + 9*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(0.82*x1 + 1.29*x2 >= 43, "growth_speed_min")
m.addConstr(-8*x1 + 8*x2 >= 0, "coleus_roses_ratio")
m.addConstr(0.82*x1 + 1.29*x2 <= 117, "growth_speed_max")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Coleus: {x1.x}")
    print(f"Roses: {x2.x}")
else:
    print("No optimal solution found")
