
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
coleus = m.addVar(name="coleus", vtype=gp.GRB.INTEGER)
roses = m.addVar(name="roses", vtype=gp.GRB.INTEGER)

# Objective function
m.setObjective(2 * coleus + 9 * roses, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(0.82 * coleus + 1.29 * roses >= 43, name="growth_speed_constraint")
m.addConstr(-8 * coleus + 8 * roses >= 0, name="balance_constraint")
m.addConstr(0.82 * coleus + 1.29 * roses <= 117, name="upper_bound_constraint")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Coleus: {coleus.varValue}, Roses: {roses.varValue}")
else:
    print("No optimal solution found.")
