
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="x0") # milligrams of vitamin B5
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1") # milligrams of vitamin B7
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2") # grams of fiber
    x3 = m.addVar(vtype=gp.GRB.INTEGER, name="x3") # milligrams of vitamin A


    # Set objective function
    m.setObjective(3*x0*x1 + 3*x0*x2 + 5*x0*x3 + 5*x1*x3 + 9*x2*x3 + 7*x1 + 2*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(5*x0 + 5*x1 + 6*x2 + 4*x3 <= 71, "c0")
    m.addConstr(5*x0 + 6*x2 >= 17, "c1")
    m.addConstr(5*x0 + 5*x1 >= 12, "c2")
    m.addConstr(6*x2 + 4*x3 >= 11, "c3")
    m.addConstr(5*x1*x1 + 4*x3*x3 >= 13, "c4")
    m.addConstr(5*x0 + 5*x1 + 6*x2 >= 12, "c5")
    m.addConstr(5*x0 + 5*x1 + 4*x3 >= 12, "c6")
    m.addConstr(5*x0*x0 + 5*x1*x1 + 6*x2*x2 >= 17, "c7")
    m.addConstr(5*x0*x0 + 5*x1*x1 + 4*x3*x3 >= 17, "c8")
    m.addConstr(5*x0 + 6*x2 <= 50, "c9")
    m.addConstr(5*x0 + 5*x1 + 6*x2 + 4*x3 <= 50, "c10")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Objective Value:', m.objVal)
        for v in m.getVars():
            print(f'{v.varName}: {v.x}')
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GrorbiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
