
import gurobi as gp
from gurobi import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x1 = m.addVar(name="x1", vtype=GRB.INTEGER)  # milligrams of vitamin B5
x2 = m.addVar(name="x2")  # milligrams of vitamin B7
x3 = m.addVar(name="x3")  # grams of fiber
x4 = m.addVar(name="x4")  # milligrams of vitamin A

# Objective function
m.setObjective(3*x1*x2 + 3*x1*x3 + 5*x1*x4 + 5*x2*x4 + 9*x3*x4 + 7*x2 + 2*x3, GRB.MAXIMIZE)

# Constraints
m.addConstr(5*x1 <= 71)
m.addConstr(5*x2 <= 71)
m.addConstr(6*x3 <= 71)
m.addConstr(4*x4 <= 71)
m.addConstr(5*x1 + 6*x3 >= 17)
m.addConstr(5*x1 + 5*x2 >= 12)
m.addConstr(6*x3 + 4*x4 >= 11)
m.addConstr(25*x2**2 + 16*x4**2 >= 13)
m.addConstr(5*x1 + 5*x2 + 6*x3 >= 12)
m.addConstr(5*x1 + 5*x2 + 4*x4 >= 12)
m.addConstr(25*x1**2 + 25*x2**2 + 36*x3**2 >= 17)
m.addConstr(25*x1**2 + 25*x2**2 + 16*x4**2 >= 17)
m.addConstr(5*x1 + 6*x3 <= 50)
m.addConstr(5*x1 + 5*x2 + 6*x3 + 4*x4 <= 50)

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
    print("x4: ", x4.varValue)
else:
    print("The model is infeasible")
