
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="rotisserie_chickens")
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="chicken_thighs")
x2 = m.addVar(vtype=gp.GRB.INTEGER, name="black_beans")
x3 = m.addVar(vtype=gp.GRB.INTEGER, name="ravioli")

# Set objective function
m.setObjective(4.68 * x0 + 3.22 * x1 + 3.47 * x2 + 3.73 * x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(14 * x2 + 4 * x3 >= 43, "c1")
m.addConstr(16 * x0 + 14 * x2 >= 43, "c2")
m.addConstr(16 * x0 + 15 * x1 + 14 * x2 >= 63, "c3")
m.addConstr(16 * x0 + 15 * x1 + 4 * x3 >= 63, "c4")
m.addConstr(16 * x0 + 15 * x1 + 14 * x2 >= 52, "c5")
m.addConstr(16 * x0 + 15 * x1 + 4 * x3 >= 52, "c6")
m.addConstr(27 * x1 + 2 * x2 >= 40, "c7")
m.addConstr(2 * x2 + 15 * x3 >= 48, "c8")
m.addConstr(23 * x0 + 2 * x2 >= 46, "c9")
m.addConstr(23 * x0 + 27 * x1 >= 51, "c10")
m.addConstr(23 * x0 + 15 * x3 >= 52, "c11")
m.addConstr(27 * x1 + 2 * x2 + 15 * x3 >= 82, "c12")
m.addConstr(6 * x1 + 5 * x3 >= 52, "c13")
m.addConstr(24 * x2 + 5 * x3 >= 87, "c14")
m.addConstr(6 * x1 + 24 * x2 >= 72, "c15")
m.addConstr(16 * x0 + 15 * x1 <= 128, "c16")
m.addConstr(14 * x2 + 4 * x3 <= 130, "c17")
m.addConstr(16 * x0 + 15 * x1 + 14 * x2 + 4 * x3 <= 130, "c18")
m.addConstr(18 * x2 + 17 * x3 <= 227, "c19")
m.addConstr(16 * x0 + 18 * x2 <= 401, "c20")
m.addConstr(16 * x0 + 17 * x3 <= 376, "c21")
m.addConstr(16 * x0 + 16 * x1 <= 233, "c22")
m.addConstr(16 * x1 + 17 * x3 <= 330, "c23")
m.addConstr(16 * x1 + 18 * x2 + 17 * x3 <= 438, "c24")
m.addConstr(16 * x0 + 16 * x1 + 18 * x2 <= 168, "c25")
m.addConstr(16 * x0 + 18 * x2 + 17 * x3 <= 458, "c26")
m.addConstr(16 * x0 + 16 * x1 + 17 * x3 <= 274, "c27")
m.addConstr(16 * x0 + 16 * x1 + 18 * x2 + 17 * x3 <= 274, "c28")
m.addConstr(27 * x0 + 25 * x2 <= 527, "c29")
m.addConstr(29 * x1 + 24 * x3 <= 312, "c30")
m.addConstr(29 * x1 + 25 * x2 <= 298, "c31")
m.addConstr(29 * x1 + 25 * x2 + 24 * x3 <= 533, "c32")
m.addConstr(27 * x0 + 29 * x1 + 25 * x2 <= 264, "c33")
m.addConstr(27 * x0 + 25 * x2 + 24 * x3 <= 464, "c34")
m.addConstr(27 * x0 + 29 * x1 + 25 * x2 + 24 * x3 <= 464, "c35")
m.addConstr(27 * x1 + 15 * x3 <= 133, "c36")
m.addConstr(23 * x0 + 27 * x1 <= 403, "c37")
m.addConstr(23 * x0 + 27 * x1 + 2 * x2 + 15 * x3 <= 403, "c38")
m.addConstr(27 * x0 + 5 * x3 <= 203, "c39")
m.addConstr(27 * x0 + 6 * x1 + 24 * x2 + 5 * x3 <= 203, "c40")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

