
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="rotisserie_chickens", vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name="chicken_thighs", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="black_beans", vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name="ravioli", vtype=gurobi.GRB.INTEGER)

# Define the objective function
m.setObjective(4.68*x0 + 3.22*x1 + 3.47*x2 + 3.73*x3, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(16*x0 + 15*x1 + 14*x2 + 4*x3 <= 258)
m.addConstr(16*x0 + 16*x1 + 18*x2 + 17*x3 <= 511)
m.addConstr(27*x0 + 29*x1 + 25*x2 + 24*x3 <= 551)
m.addConstr(23*x0 + 27*x1 + 2*x2 + 15*x3 <= 409)
m.addConstr(27*x0 + 6*x1 + 24*x2 + 5*x3 <= 388)
m.addConstr(14*x2 + 4*x3 >= 43)
m.addConstr(16*x0 + 14*x2 >= 43)
m.addConstr(16*x0 + 15*x1 + 14*x2 >= 63)
m.addConstr(16*x0 + 15*x1 + 4*x3 >= 63)
m.addConstr(16*x0 + 15*x1 + 14*x2 >= 52)
m.addConstr(16*x0 + 15*x1 + 4*x3 >= 52)
m.addConstr(27*x1 + 2*x2 >= 40)
m.addConstr(2*x2 + 15*x3 >= 48)
m.addConstr(23*x0 + 2*x2 >= 46)
m.addConstr(23*x0 + 27*x1 >= 51)
m.addConstr(23*x0 + 15*x3 >= 52)
m.addConstr(27*x1 + 2*x2 + 15*x3 >= 82)
m.addConstr(6*x1 + 5*x3 >= 52)
m.addConstr(24*x2 + 5*x3 >= 87)
m.addConstr(6*x1 + 24*x2 >= 72)
m.addConstr(16*x0 + 15*x1 <= 128)
m.addConstr(14*x2 + 4*x3 <= 130)
m.addConstr(16*x0 + 15*x1 + 14*x2 + 4*x3 <= 130)
m.addConstr(18*x2 + 17*x3 <= 227)
m.addConstr(16*x0 + 18*x2 <= 401)
m.addConstr(16*x0 + 17*x3 <= 376)
m.addConstr(16*x0 + 16*x1 <= 233)
m.addConstr(16*x1 + 17*x3 <= 330)
m.addConstr(16*x1 + 18*x2 + 17*x3 <= 438)
m.addConstr(16*x0 + 16*x1 + 18*x2 <= 168)
m.addConstr(16*x0 + 18*x2 + 17*x3 <= 458)
m.addConstr(16*x0 + 16*x1 + 17*x3 <= 274)
m.addConstr(16*x0 + 16*x1 + 18*x2 + 17*x3 <= 274)
m.addConstr(27*x0 + 25*x2 <= 527)
m.addConstr(29*x1 + 24*x3 <= 312)
m.addConstr(29*x1 + 25*x2 <= 298)
m.addConstr(29*x1 + 25*x2 + 24*x3 <= 533)
m.addConstr(27*x0 + 29*x1 + 25*x2 <= 264)
m.addConstr(27*x0 + 25*x2 + 24*x3 <= 464)
m.addConstr(27*x0 + 29*x1 + 25*x2 + 24*x3 <= 464)
m.addConstr(27*x1 + 15*x3 <= 133)
m.addConstr(23*x0 + 27*x1 <= 403)
m.addConstr(23*x0 + 27*x1 + 2*x2 + 15*x3 <= 403)
m.addConstr(27*x0 + 5*x3 <= 203)
m.addConstr(27*x0 + 6*x1 + 24*x2 + 5*x3 <= 203)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("rotisserie chickens: ", x0.varValue)
    print("chicken thighs: ", x1.varValue)
    print("black beans: ", x2.varValue)
    print("ravioli: ", x3.varValue)
else:
    print("No solution found")
