
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
vitamin_d = m.addVar(lb=0, name="vitamin_d")
vitamin_b9 = m.addVar(lb=0, name="vitamin_b9")
fat = m.addVar(lb=0, name="fat")
vitamin_a = m.addVar(lb=0, name="vitamin_a")
zinc = m.addVar(lb=0, name="zinc")


# Set objective function
m.setObjective(2.81 * vitamin_d + 2.88 * vitamin_b9 + 9.36 * fat + 5.77 * vitamin_a + 8.15 * zinc, gp.GRB.MAXIMIZE)

# Add constraints based on the provided resources and attributes
resources = {
    'r0': {'upper_bound': 650, 'x0': 28.61, 'x1': 32.03, 'x2': 2.77, 'x3': 11.61, 'x4': 22.06},
    'r1': {'upper_bound': 340, 'x0': 3.17, 'x1': 9.59, 'x2': 22.63, 'x3': 1.77, 'x4': 14.5},
    'r2': {'upper_bound': 622, 'x0': 1.67, 'x1': 5.03, 'x2': 5.79, 'x3': 27.34, 'x4': 22.06}
}

for r_key, r_data in resources.items():
    m.addConstr(r_data['x0'] * vitamin_d + r_data['x1'] * vitamin_b9 + r_data['x2'] * fat + r_data['x3'] * vitamin_a + r_data['x4'] * zinc <= r_data['upper_bound'], name=r_key)


# Add other constraints from the problem description (simplified and deduplicated)
m.addConstr(11.61 * vitamin_a + 22.06 * zinc >= 97)
m.addConstr(2.77 * fat + 11.61 * vitamin_a >= 51)
m.addConstr(32.03 * vitamin_b9 + 22.06 * zinc >= 105)
m.addConstr(28.61 * vitamin_d + 22.06 * zinc >= 122)
m.addConstr(32.03 * vitamin_b9 + 2.77 * fat >= 63)
m.addConstr(2.77 * fat + 22.06 * zinc >= 101)
m.addConstr(28.61 * vitamin_d + 32.03 * vitamin_b9 + 11.61 * vitamin_a >= 116)
m.addConstr(32.03 * vitamin_b9 + 11.61 * vitamin_a + 22.06 * zinc >= 122)
m.addConstr(28.61 * vitamin_d + 32.03 * vitamin_b9 + 22.06 * zinc >= 116)
m.addConstr(2.77 * fat + 11.61 * vitamin_a + 22.06 * zinc >= 122)
m.addConstr(32.03 * vitamin_b9 + 2.77 * fat + 11.61 * vitamin_a >= 122)
m.addConstr(28.61 * vitamin_d + 11.61 * vitamin_a + 22.06 * zinc >= 122)
m.addConstr(32.03 * vitamin_b9 + 2.77 * fat + 22.06 * zinc >= 122)
m.addConstr(3.17 * vitamin_d + 9.59 * vitamin_b9 >= 24)
m.addConstr(5.79 * fat + 27.34 * vitamin_a >= 43)
m.addConstr(5.79 * fat + 22.06 * zinc >= 122)
m.addConstr(28.61 * vitamin_d + 2.77 * fat <= 299)
m.addConstr(32.03 * vitamin_b9 + 11.61 * vitamin_a <= 631)
m.addConstr(28.61 * vitamin_d + 32.03 * vitamin_b9 <= 304)
m.addConstr(2.77 * fat + 11.61 * vitamin_a <= 381)
m.addConstr(28.61 * vitamin_d + 11.61 * vitamin_a <= 351)
m.addConstr(9.59 * vitamin_b9 + 14.5 * zinc <= 322)
m.addConstr(1.77 * vitamin_a + 14.5 * zinc <= 280)
m.addConstr(27.34 * vitamin_a + 22.06 * zinc <= 358)
m.addConstr(5.03 * vitamin_b9 + 27.34 * vitamin_a <= 615)
m.addConstr(5.79 * fat + 22.06 * zinc <= 593)
m.addConstr(1.67 * vitamin_d + 5.03 * vitamin_b9 <= 345)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

