
import gurobipy as gp

# Create a new model
m = gp.Model("likelihood_to_quit_optimization")

# Create variables
ringo = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ringo")
mary = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="mary")
laura = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura")
jean = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="jean")
hank = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank")
john = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="john")


# Set objective
m.setObjective(6.8 * ringo + 4.4 * mary + 4.92 * laura + 1.59 * jean + 7.47 * hank + 2.36 * john, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(10 * ringo + 2 * laura >= 47)
m.addConstr(2 * jean + 10 * hank >= 47)
m.addConstr(2 * jean + 6 * john >= 47)
m.addConstr(10 * hank + 6 * john >= 38)
m.addConstr(5 * mary + 10 * hank >= 27)
m.addConstr(2 * laura + 2 * jean >= 37)
m.addConstr(10 * ringo + 2 * laura + 2 * jean >= 37)
m.addConstr(5 * mary + 2 * laura + 6 * john >= 37)
m.addConstr(10 * ringo + 5 * mary + 2 * laura >= 37)
m.addConstr(10 * ringo + 5 * mary + 6 * john >= 37)
m.addConstr(10 * ringo + 2 * laura + 2 * jean >= 38)
m.addConstr(5 * mary + 2 * laura + 6 * john >= 38)
m.addConstr(10 * ringo + 5 * mary + 2 * laura >= 38)
m.addConstr(10 * ringo + 5 * mary + 6 * john >= 38)
m.addConstr(10 * ringo + 2 * laura + 2 * jean >= 37)
m.addConstr(5 * mary + 2 * laura + 6 * john >= 37)
m.addConstr(10 * ringo + 5 * mary + 2 * laura >= 37)
m.addConstr(10 * ringo + 5 * mary + 6 * john >= 37)
m.addConstr(10 * ringo + 2 * laura + 2 * jean >= 29)
m.addConstr(5 * mary + 2 * laura + 6 * john >= 29)
m.addConstr(10 * ringo + 5 * mary + 2 * laura >= 29)
m.addConstr(10 * ringo + 5 * mary + 6 * john >= 29)
m.addConstr(mary - 9 * hank + 5 * john >= 0)
m.addConstr(5 * mary + 10 * hank <= 144)
m.addConstr(5 * mary + 2 * jean <= 163)
m.addConstr(10 * ringo + 2 * jean <= 176)
m.addConstr(2 * laura + 6 * john <= 225)
m.addConstr(5 * mary + 10 * hank + 6 * john <= 59)
m.addConstr(10 * ringo + 5 * mary + 2 * jean <= 105)
m.addConstr(10 * ringo + 2 * laura + 6 * john <= 133)
m.addConstr(2 * laura + 2 * jean + 10 * hank <= 56)
m.addConstr(10 * ringo + 5 * mary + 10 * hank <= 223)
m.addConstr(5 * mary + 2 * jean + 10 * hank <= 192)
m.addConstr(5 * mary + 2 * laura + 2 * jean <= 107)
m.addConstr(2 * laura + 2 * jean + 6 * john <= 188)
m.addConstr(10 * ringo + 2 * laura + 2 * jean <= 108)
m.addConstr(10 * ringo + 5 * mary + 2 * laura + 2 * jean + 10 * hank + 6 * john <= 108)


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

