
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name='x1', lb=0)  # hours worked by Ringo
    x2 = model.addVar(name='x2', lb=0)  # hours worked by Mary
    x3 = model.addVar(name='x3', lb=0)  # hours worked by Laura
    x4 = model.addVar(name='x4', lb=0)  # hours worked by Jean
    x5 = model.addVar(name='x5', lb=0)  # hours worked by Hank
    x6 = model.addVar(name='x6', lb=0)  # hours worked by John

    # Objective function
    model.setObjective(6.8 * x1 + 4.4 * x2 + 4.92 * x3 + 1.59 * x4 + 7.47 * x5 + 2.36 * x6, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(10 * x1 <= 283)
    model.addConstr(5 * x2 <= 283)
    model.addConstr(2 * x3 <= 283)
    model.addConstr(2 * x4 <= 283)
    model.addConstr(10 * x5 <= 283)
    model.addConstr(6 * x6 <= 283)

    model.addConstr(10 * x1 + 2 * x3 >= 47)
    model.addConstr(2 * x4 + 10 * x5 >= 47)
    model.addConstr(2 * x4 + 6 * x6 >= 47)
    model.addConstr(10 * x5 + 6 * x6 >= 38)
    model.addConstr(5 * x2 + 10 * x5 >= 27)
    model.addConstr(2 * x3 + 2 * x4 >= 37)
    model.addConstr(10 * x1 + 2 * x3 + 2 * x4 >= 37)
    model.addConstr(5 * x2 + 2 * x3 + 6 * x6 >= 37)
    model.addConstr(10 * x1 + 5 * x2 + 2 * x3 >= 37)
    model.addConstr(10 * x1 + 5 * x2 + 6 * x6 >= 37)
    model.addConstr(10 * x1 + 2 * x3 + 2 * x4 >= 38)
    model.addConstr(5 * x2 + 2 * x3 + 6 * x6 >= 38)
    model.addConstr(10 * x1 + 5 * x2 + 2 * x3 >= 38)
    model.addConstr(10 * x1 + 5 * x2 + 6 * x6 >= 38)

    model.addConstr(10 * x1 + 2 * x3 + 2 * x4 >= 37)
    model.addConstr(5 * x2 + 2 * x3 + 6 * x6 >= 37)
    model.addConstr(10 * x1 + 5 * x2 + 2 * x3 >= 37)
    model.addConstr(10 * x1 + 5 * x2 + 6 * x6 >= 37)

    model.addConstr(10 * x1 + 2 * x3 + 2 * x4 >= 29)
    model.addConstr(5 * x2 + 2 * x3 + 6 * x6 >= 29)
    model.addConstr(10 * x1 + 5 * x2 + 2 * x3 >= 29)
    model.addConstr(10 * x1 + 5 * x2 + 6 * x6 >= 29)

    model.addConstr(x2 - 9 * x5 + 5 * x6 >= 0)
    model.addConstr(5 * x2 + 10 * x5 <= 144)
    model.addConstr(5 * x2 + 2 * x4 <= 163)
    model.addConstr(10 * x1 + 2 * x4 <= 176)
    model.addConstr(2 * x3 + 6 * x6 <= 225)
    model.addConstr(5 * x2 + 10 * x5 + 6 * x6 <= 59)
    model.addConstr(10 * x1 + 5 * x2 + 2 * x4 <= 105)
    model.addConstr(10 * x1 + 2 * x3 + 6 * x6 <= 133)
    model.addConstr(2 * x3 + 2 * x4 + 10 * x5 <= 56)
    model.addConstr(10 * x1 + 5 * x2 + 10 * x5 <= 223)
    model.addConstr(5 * x2 + 2 * x4 + 10 * x5 <= 192)
    model.addConstr(5 * x2 + 2 * x3 + 2 * x4 <= 107)
    model.addConstr(2 * x3 + 2 * x4 + 6 * x6 <= 188)
    model.addConstr(10 * x1 + 2 * x3 + 2 * x4 <= 108)
    model.addConstr(10 * x1 + 5 * x2 + 2 * x3 + 2 * x4 + 10 * x5 + 6 * x6 <= 108)

    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Ringo: {x1.varValue}")
        print(f"Hours worked by Mary: {x2.varValue}")
        print(f"Hours worked by Laura: {x3.varValue}")
        print(f"Hours worked by Jean: {x4.varValue}")
        print(f"Hours worked by Hank: {x5.varValue}")
        print(f"Hours worked by John: {x6.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
