
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    honeypots = m.addVar(vtype=gp.GRB.INTEGER, name="honeypots")
    bandwidth = m.addVar(vtype=gp.GRB.INTEGER, name="Mbps bandwidth allocated to monitoring")
    engineers = m.addVar(vtype=gp.GRB.INTEGER, name="security engineers")

    # Set objective function
    m.setObjective(5.65 * honeypots + 6.9 * bandwidth + 1.66 * engineers, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(9 * honeypots + 5 * bandwidth + 2 * engineers <= 115, "dollar cost")
    m.addConstr(9 * honeypots + 7 * bandwidth + 3 * engineers <= 89, "data integrity impact")
    m.addConstr(3 * honeypots + 4 * bandwidth + 8 * engineers <= 185, "network latency impact")
    m.addConstr(6 * honeypots + 2 * bandwidth + 5 * engineers <= 139, "power consumption")
    m.addConstr(11 * honeypots + 9 * bandwidth + 9 * engineers <= 141, "data confidentiality impact")
    m.addConstr(9 * honeypots + 5 * bandwidth + 2 * engineers >= 38, "min cost")
    m.addConstr(6 * honeypots + 5 * engineers >= 30, "min power hp + eng")
    m.addConstr(6 * honeypots + 2 * bandwidth >= 43, "min power hp + bw")
    m.addConstr(9 * honeypots + 5 * bandwidth <= 91, "max cost hp + bw")
    m.addConstr(9 * honeypots + 2 * engineers <= 46, "max cost hp + eng")
    m.addConstr(9 * honeypots + 5 * bandwidth + 2 * engineers <= 46, "max cost all")
    m.addConstr(9 * honeypots + 3 * engineers <= 34, "max di hp + eng")
    m.addConstr(7 * bandwidth + 3 * engineers <= 52, "max di bw + eng")
    m.addConstr(9 * honeypots + 7 * bandwidth + 3 * engineers <= 57, "max di all")
    m.addConstr(3 * honeypots + 4 * bandwidth <= 98, "max latency hp + bw")
    m.addConstr(4 * bandwidth + 8 * engineers <= 90, "max latency bw + eng")
    m.addConstr(3 * honeypots + 4 * bandwidth + 8 * engineers <= 94, "max latency all")
    m.addConstr(2 * bandwidth + 5 * engineers <= 130, "max power bw + eng")
    m.addConstr(6 * honeypots + 5 * engineers <= 58, "max power hp + eng")
    m.addConstr(6 * honeypots + 2 * bandwidth + 5 * engineers <= 58, "max power all")
    m.addConstr(11 * honeypots + 9 * engineers <= 129, "max dc hp + eng")
    m.addConstr(9 * bandwidth + 9 * engineers <= 59, "max dc bw + eng")
    m.addConstr(11 * honeypots + 9 * bandwidth <= 49, "max dc hp + bw")
    m.addConstr(11 * honeypots + 9 * bandwidth + 9 * engineers <= 49, "max dc all")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('honeypots:', honeypots.x)
        print('bandwidth:', bandwidth.x)
        print('engineers:', engineers.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
