
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
cherry_pies = m.addVar(lb=0, name="cherry_pies")
oreos = m.addVar(lb=0, name="oreos")
apples = m.addVar(lb=0, name="apples")


# Set objective function
m.setObjective(6*cherry_pies**2 + 7*cherry_pies*oreos + 9*cherry_pies*apples + 4*oreos**2 + 1*oreos*apples + 6*apples**2 + 8*oreos + 1*apples, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(16*cherry_pies + 9*oreos + 1*apples <= 99, "c1")
m.addConstr(13*cherry_pies + 2*oreos + 8*apples <= 138, "c2")
m.addConstr(12*cherry_pies + 5*oreos + 2*apples <= 87, "c3")
m.addConstr(5*cherry_pies + 5*oreos + 8*apples <= 131, "c4")
m.addConstr(9*oreos + 1*apples >= 27, "c5")
m.addConstr(16*cherry_pies**2 + 9*oreos**2 >= 29, "c6")
m.addConstr(16*cherry_pies + 9*oreos + 1*apples >= 29, "c7")
m.addConstr(13*cherry_pies**2 + 8*apples**2 >= 42, "c8")
m.addConstr(2*oreos + 8*apples >= 16, "c9")
m.addConstr(13*cherry_pies + 2*oreos + 8*apples >= 16, "c10")
m.addConstr(12*cherry_pies + 5*oreos >= 16, "c11")
m.addConstr(5*oreos**2 + 2*apples**2 >= 20, "c12")
m.addConstr(12*cherry_pies + 5*oreos + 2*apples >= 20, "c13")
m.addConstr(5*cherry_pies + 5*oreos >= 27, "c14")
m.addConstr(5*oreos**2 + 8*apples**2 >= 40, "c15")
m.addConstr(5*cherry_pies + 5*oreos + 8*apples >= 40, "c16")
m.addConstr(1*cherry_pies - 9*apples >= 0, "c17")
m.addConstr(9*oreos + apples <= 80, "c18")
m.addConstr(13*cherry_pies**2 + 2*oreos**2 + 8*apples**2 <= 94, "c19")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

