
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="cherry_pies", lb=-gp.GRB.INFINITY)
x1 = m.addVar(name="oreos", lb=-gp.GRB.INFINITY)
x2 = m.addVar(name="apples", lb=-gp.GRB.INFINITY)

# Define the objective function
m.setObjective(6*x0**2 + 7*x0*x1 + 9*x0*x2 + 4*x1**2 + x1*x2 + 6*x2**2 + 8*x1 + x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(9*x1 + x2 >= 27)
m.addConstr(16*x0**2 + 9*x1**2 >= 29)
m.addConstr(16*x0 + 9*x1 + x2 >= 29)
m.addConstr(169*x0**2 + 64*x2**2 >= 42)
m.addConstr(2*x1 + 8*x2 >= 16)
m.addConstr(13*x0 + 2*x1 + 8*x2 >= 16)
m.addConstr(12*x0 + 5*x1 >= 16)
m.addConstr(25*x1**2 + 4*x2**2 >= 20)
m.addConstr(12*x0 + 5*x1 + 2*x2 >= 20)
m.addConstr(5*x0 + 5*x1 >= 27)
m.addConstr(25*x1**2 + 64*x2**2 >= 40)
m.addConstr(5*x0 + 5*x1 + 8*x2 >= 40)
m.addConstr(x0 - 9*x2 >= 0)
m.addConstr(9*x1 + x2 <= 80)
m.addConstr(169*x0**2 + 4*x1**2 + 64*x2**2 <= 94)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x0 (cherry pies): ", x0.varValue)
    print("x1 (oreos): ", x1.varValue)
    print("x2 (apples): ", x2.varValue)
else:
    print("The model is infeasible")
